/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.entities.SkyhookUserData;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class SkyhookItem
extends UpgradeableToolItem
implements IElectricEquipment {
    public static final String TYPE = "SKYHOOK";

    public SkyhookItem() {
        super(new Item.Properties().stacksTo(1).component(IEDataComponents.SKYHOOK_SPEED_LIMIT, (Object)false), TYPE, 2);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.skyhook").withStyle(ChatFormatting.GRAY));
        if (SkyhookItem.shouldLimitSpeed(stack)) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.skyhook.speedLimit").withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.skyhook.noLimit").withStyle(ChatFormatting.GRAY));
        }
    }

    public static boolean shouldLimitSpeed(ItemStack stack) {
        return (Boolean)stack.getOrDefault(IEDataComponents.SKYHOOK_SPEED_LIMIT, (Object)false);
    }

    public static void setLimitSpeed(ItemStack stack, boolean doLimit) {
        stack.set(IEDataComponents.SKYHOOK_SPEED_LIMIT, (Object)doLimit);
    }

    public static boolean toggleSpeedLimit(ItemStack stack) {
        boolean wasActive = SkyhookItem.shouldLimitSpeed(stack);
        SkyhookItem.setLimitSpeed(stack, !wasActive);
        return !wasActive;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity ent, int slot, boolean inHand) {
        super.inventoryTick(stack, world, ent, slot, inHand);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(IEApi.ieLoc("weapon_modifier_damage"), 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(IEApi.ieLoc("weapon_modifier_speed"), -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    private static boolean canSmash(LivingEntity entity) {
        return entity.fallDistance > 1.5f && !entity.isFallFlying() && SkyhookItem.getUpgradesStatic(entity.getMainHandItem()).has(UpgradeEffect.MACE_ATTACK);
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        LivingEntity livingentity;
        Entity attacker = damageSource.getDirectEntity();
        if (attacker instanceof LivingEntity && SkyhookItem.canSmash(livingentity = (LivingEntity)attacker)) {
            float fallDistance = livingentity.fallDistance;
            float damageBonus = fallDistance <= 3.0f ? 4.0f * fallDistance : (fallDistance <= 8.0f ? 12.0f + 2.0f * (fallDistance - 3.0f) : 22.0f + fallDistance - 8.0f);
            return damageBonus;
        }
        return 0.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (SkyhookItem.canSmash(attacker)) {
            attacker.resetFallDistance();
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.isShiftKeyDown()) {
            boolean limitSpeed = SkyhookItem.toggleSpeedLimit(stack);
            if (limitSpeed) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.skyhookLimited"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.skyhookUnlimited"), true);
            }
        } else {
            SkyhookUserData data = (SkyhookUserData)player.getData(IEDataAttachments.SKYHOOK_USER.get());
            if (data.hook != null && !world.isClientSide) {
                data.dismount();
                IELogger.logger.info("Player left voluntarily");
            } else {
                data.startHolding();
                player.startUsingItem(hand);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        super.onUseTick(level, player, stack, count);
        SkyhookUserData data = (SkyhookUserData)player.getData(IEDataAttachments.SKYHOOK_USER.get());
        if (data.getStatus() != SkyhookUserData.SkyhookStatus.HOLDING_CONNECTING) {
            return;
        }
        Connection con = WireUtils.getConnectionMovedThrough(level, player);
        if (con != null) {
            SkylineHelper.spawnHook(player, con, player.getUsedItemHand(), SkyhookItem.shouldLimitSpeed(stack), this.getSlopeModifier(stack));
        }
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity player, int timeLeft) {
        super.releaseUsing(stack, worldIn, player, timeLeft);
        if (!worldIn.isClientSide) {
            ((SkyhookUserData)player.getData(IEDataAttachments.SKYHOOK_USER.get())).release();
        }
    }

    public float getSlopeModifier(ItemStack stack) {
        UpgradeData upgrades = this.getUpgrades(stack);
        return Math.max(upgrades.get(UpgradeEffect.SLOPE_MODIFIER).floatValue(), 0.5f);
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlot eqSlot, LivingEntity owner, Map<String, Object> cache, @Nullable DamageSource dmg, IElectricEquipment.ElectricSource desc) {
        if (dmg instanceof IEDamageSources.ElectricDamageSource) {
            IEDamageSources.ElectricDamageSource eds = (IEDamageSources.ElectricDamageSource)dmg;
            if (dmg.is(Lib.DamageTypes.WIRE_SHOCK) && this.getUpgrades(equipped).has(UpgradeEffect.INSULATED) && (owner.getVehicle() instanceof SkylineHookEntity || owner.isUsingItem())) {
                eds.dmg = 0.0f;
            }
        }
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 72000;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 102, 42, TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 102, 22, TYPE, stack, true, level, getPlayer)};
    }
}

