/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.gui.IScreenMessageReceive;
import blusunrize.immersiveengineering.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageContainerUpdate(int windowId, CompoundTag nbt) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageContainerUpdate> ID = IMessage.createType("container_update");
    public static final StreamCodec<ByteBuf, MessageContainerUpdate> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageContainerUpdate::windowId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, MessageContainerUpdate::nbt, MessageContainerUpdate::new);

    @Override
    public void process(IPayloadContext context) {
        ServerPlayer player = IMessage.serverPlayer(context);
        context.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp;
            player.resetLastActionTime();
            if (player.containerMenu.containerId == this.windowId && (patt0$temp = player.containerMenu) instanceof IScreenMessageReceive) {
                IScreenMessageReceive ieMenu = (IScreenMessageReceive)patt0$temp;
                ieMenu.receiveMessageFromScreen(this.nbt);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

