/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IESounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageSpeedloaderSync(int slot, InteractionHand hand) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageSpeedloaderSync> ID = IMessage.createType("speedloader_sync");
    public static final StreamCodec<ByteBuf, MessageSpeedloaderSync> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageSpeedloaderSync::slot, (StreamCodec)ByteBufCodecs.idMapper(i -> InteractionHand.values()[i], Enum::ordinal), MessageSpeedloaderSync::hand, MessageSpeedloaderSync::new);

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = ImmersiveEngineering.proxy.getClientPlayer();
            if (player != null) {
                if (player.getItemInHand(this.hand).getItem() instanceof RevolverItem) {
                    player.playSound((SoundEvent)IESounds.revolverReload.value(), 1.0f, 1.0f);
                    player.getItemInHand(this.hand).set(IEDataComponents.REVOLVER_COOLDOWN, (Object)new RevolverItem.RevolverCooldowns(60, 0));
                }
                player.getInventory().setItem(this.slot, new ItemStack(IEItems.Weapons.SPEEDLOADER));
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

