/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.EarmuffsItem;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class IEBlockEntitySound
implements TickableSoundInstance {
    protected Sound sound;
    private final ResourceLocation resource;
    private final float volume;
    private final float pitch;
    private final BlockPos tilePos;
    private float volumeAjustment = 1.0f;
    public boolean donePlaying = false;

    public IEBlockEntitySound(SoundEvent event, float volume, float pitch, BlockPos pos) {
        this.resource = event.getLocation();
        this.volume = volume;
        this.pitch = pitch;
        this.tilePos = pos;
    }

    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.LINEAR;
    }

    public ResourceLocation getLocation() {
        return this.resource;
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager handler) {
        WeighedSoundEvents soundEvent = handler.getSoundEvent(this.resource);
        this.sound = soundEvent == null ? SoundManager.EMPTY_SOUND : soundEvent.getSound(ApiUtils.RANDOM_SOURCE);
        return soundEvent;
    }

    public Sound getSound() {
        return this.sound;
    }

    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    public float getVolume() {
        return this.volume * this.volumeAjustment;
    }

    public float getPitch() {
        return this.pitch;
    }

    public double getX() {
        return this.tilePos.getX();
    }

    public double getY() {
        return this.tilePos.getY();
    }

    public double getZ() {
        return this.tilePos.getZ();
    }

    public boolean isLooping() {
        return true;
    }

    public boolean isRelative() {
        return false;
    }

    public int getDelay() {
        return 0;
    }

    public void evaluateVolume() {
        BlockEntity tile;
        ItemStack earmuffs;
        this.volumeAjustment = 1.0f;
        if (ClientUtils.mc().player != null && !(earmuffs = EarmuffsItem.EARMUFF_GETTERS.getFrom((LivingEntity)ClientUtils.mc().player)).isEmpty()) {
            this.volumeAjustment = EarmuffsItem.getVolumeMod(earmuffs);
        }
        if (!((tile = ClientUtils.mc().player.level().getBlockEntity(this.tilePos)) instanceof IEBlockInterfaces.ISoundBE)) {
            this.donePlaying = true;
        } else {
            IEBlockInterfaces.ISoundBE soundBE = (IEBlockInterfaces.ISoundBE)tile;
            boolean bl = this.donePlaying = !soundBE.shouldPlaySound(this.resource.toString());
            if (!this.donePlaying) {
                float radiusSq = soundBE.getSoundRadiusSq();
                if (ClientUtils.mc().player != null) {
                    double distSq = ClientUtils.mc().player.distanceToSqr(Vec3.atCenterOf((Vec3i)this.tilePos));
                    if (distSq > (double)radiusSq) {
                        this.donePlaying = true;
                    } else {
                        this.volumeAjustment = (float)((double)this.volumeAjustment * (((double)radiusSq - distSq) / (double)radiusSq));
                    }
                }
            }
        }
    }

    public void tick() {
        if (ClientUtils.mc().player != null && ClientUtils.mc().player.level().getGameTime() % 40L == 0L) {
            this.evaluateVolume();
        }
    }

    public boolean isStopped() {
        return this.donePlaying;
    }
}

