/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.network.packets;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import net.gigabit101.shrink.items.ItemShrinkDevice;
import net.gigabit101.shrink.network.PacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PacketShrinkDevice
extends BaseC2SMessage {
    InteractionHand hand;
    double scale;

    public PacketShrinkDevice(InteractionHand hand, double scale) {
        this.hand = hand;
        this.scale = scale;
    }

    public PacketShrinkDevice(FriendlyByteBuf friendlyByteBuf) {
        this.hand = friendlyByteBuf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.scale = friendlyByteBuf.readDouble();
    }

    public MessageType getType() {
        return PacketHandler.SHRINK_DEVICE;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.writeDouble(this.scale);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Item patt0$temp;
            Player player = context.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack stack = player.getItemInHand(this.hand);
            if (!stack.isEmpty() && (patt0$temp = stack.getItem()) instanceof ItemShrinkDevice) {
                ItemShrinkDevice itemShrinkDevice = (ItemShrinkDevice)patt0$temp;
                itemShrinkDevice.writeScale(stack, this.scale);
            }
        });
    }
}

