/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.utils.CodecUtils;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateSpecificTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, BlockPos pos) {
        super.trigger(serverPlayer, instance -> instance.matches(serverPlayer.level().getBlockState(pos)));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, CodecUtils.BlockMatcher blockMatcher) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)CodecUtils.BlockMatcher.CODEC.fieldOf("block").forGetter(TriggerInstance::blockMatcher)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(BlockState blockState) {
            return this.blockMatcher().blockMatched(blockState);
        }
    }
}

