/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.ProperFacingBlock;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlisteringHoneyCrystal
extends ProperFacingBlock
implements BlockExtension {
    public static final MapCodec<GlisteringHoneyCrystal> CODEC = Block.simpleCodec(GlisteringHoneyCrystal::new);

    public GlisteringHoneyCrystal() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).instrument(NoteBlockInstrument.PLING).isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).isRedstoneConductor((blockState, blockGetter, blockPos) -> false).isSuffocating((blockState, blockGetter, blockPos) -> false).isViewBlocking((blockState, blockGetter, blockPos) -> false).lightLevel(blockState -> 11).strength(0.4f, 0.4f).sound((SoundType)BzSounds.HONEY_CRYSTALS_TYPE).noOcclusion());
    }

    public GlisteringHoneyCrystal(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public MapCodec<? extends GlisteringHoneyCrystal> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[0]).add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public boolean skipRendering(BlockState blockState, BlockState blockState1, Direction direction) {
        return blockState1.is((Block)this) || super.skipRendering(blockState, blockState1, direction);
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 0.85f;
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    @Override
    public OptionalBoolean bz$shouldNotDisplayFluidOverlay() {
        return OptionalBoolean.TRUE;
    }

    public void onPlace(BlockState blockState, Level world, BlockPos blockPos, BlockState previousBlockState, boolean notify) {
        GlisteringHoneyCrystal.sugarifyNeighboringWater((LevelAccessor)world, blockPos);
        super.onPlace(blockState, world, blockPos, previousBlockState, notify);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos blockPos, Block block, BlockPos fromPos, boolean notify) {
        GlisteringHoneyCrystal.sugarifyNeighboringWater((LevelAccessor)world, blockPos);
        super.neighborChanged(state, world, blockPos, block, fromPos, notify);
    }

    private static void sugarifyNeighboringWater(LevelAccessor level, BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            BlockPos sidePos = blockPos.relative(direction);
            FluidState sideFluid = level.getFluidState(sidePos);
            if (!sideFluid.is(BzTags.CONVERTIBLE_TO_SUGAR_WATER) || sideFluid.is(BzTags.SUGAR_WATER_FLUID) || !sideFluid.isSource() || !level.getBlockState(sidePos).getShape((BlockGetter)level, sidePos).isEmpty()) continue;
            level.setBlock(sidePos, ((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState(), 3);
        }
    }

    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        if (random.nextFloat() < 0.09f) {
            this.spawnSparkleParticles(world, position, random);
        }
    }

    private void spawnSparkleParticles(Level world, BlockPos position, RandomSource random) {
        int chosenFace = random.nextInt(3);
        int min = -1;
        int max = 16;
        double x = random.nextDouble() + (double)(random.nextBoolean() ? min : max) * (chosenFace != 0 ? random.nextDouble() : 1.0);
        double y = random.nextDouble() + (double)(random.nextBoolean() ? min : max) * (chosenFace != 1 ? random.nextDouble() : 1.0);
        double z = random.nextDouble() + (double)(random.nextBoolean() ? min : max) * (chosenFace != 2 ? random.nextDouble() : 1.0);
        world.addParticle((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), x / 16.0 + (double)position.getX(), y / 16.0 + (double)position.getY(), z / 16.0 + (double)position.getZ(), 0.0, 0.0, 0.0);
    }

    public void onProjectileHit(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        if (!level.isClientSide) {
            BlockPos blockPos = blockHitResult.getBlockPos();
            level.playSound(null, blockPos, (SoundEvent)BzSounds.HONEY_CRYSTAL_BLOCK_HIT.get(), SoundSource.BLOCKS, 1.0f, 0.5f + level.random.nextFloat() * 1.2f);
            level.playSound(null, blockPos, (SoundEvent)BzSounds.HONEY_CRYSTAL_BLOCK_CHIME.get(), SoundSource.BLOCKS, 1.0f, 0.5f + level.random.nextFloat() * 1.2f);
        }
    }
}

