/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationAxisBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);
    public static final MapCodec<RotationAxisBlock> CODEC = Block.simpleCodec(RotationAxisBlock::new);

    protected RotationAxisBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    public MapCodec<? extends RotationAxisBlock> codec() {
        return CODEC;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        int rotationIndex = (Integer)state.getValue((Property)ROTATION);
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        BlockState newState = RotatedPillarBlock.rotatePillar((BlockState)state, (Rotation)rotation);
        int newRotationIndex = RotationAxisBlock.getRotatedRotation(axis, rotationIndex, rotation);
        return (BlockState)newState.setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getRotatedRotation(Direction.Axis axis, int rotationIndex, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            if ((axis != Direction.Axis.Z || i % 2 != 1) && (axis != Direction.Axis.X || i % 2 != 0)) continue;
            if (rotationIndex % 2 == 0) {
                ++rotationIndex;
                continue;
            }
            --rotationIndex;
        }
        return rotationIndex;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        int rotationIndex = (Integer)state.getValue((Property)ROTATION);
        int newRotationIndex = RotationAxisBlock.getMirroredRotation(axis, rotationIndex, mirror);
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getMirroredRotation(Direction.Axis axis, int rotationIndex, Mirror mirror) {
        boolean rotationIsEven;
        if (mirror == Mirror.NONE) {
            return rotationIndex;
        }
        boolean specialCase = mirror == Mirror.LEFT_RIGHT && axis != Direction.Axis.Y;
        boolean bl = rotationIsEven = rotationIndex % 2 == 0;
        if (specialCase && rotationIsEven || !specialCase && !rotationIsEven) {
            return (rotationIndex + 2) % 4;
        }
        return rotationIndex;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
        builder.add(new Property[]{ROTATION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Direction clickFaceDirection = blockPlaceContext.getClickedFace();
        Direction horizontalDirection = blockPlaceContext.getHorizontalDirection();
        Direction.Axis axis = Direction.Axis.Y;
        int rotation = 0;
        if (clickFaceDirection.getAxis() == Direction.Axis.Y) {
            axis = horizontalDirection.getAxis();
            if (horizontalDirection == Direction.SOUTH || horizontalDirection == Direction.WEST) {
                rotation = 1;
            }
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation));
    }
}

