/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerItemUseOnBlockEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringCurtain
extends Block {
    public static final BooleanProperty ATTACHED = BooleanProperty.create((String)"attached");
    public static final BooleanProperty CENTER = BooleanProperty.create((String)"center");
    public static final BooleanProperty IS_END = BooleanProperty.create((String)"is_end");
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected final Map<Pair<Direction, Boolean>, VoxelShape> collisionShapeByMap = this.makeShapes();
    public static final MapCodec<StringCurtain> CODEC = Block.simpleCodec(StringCurtain::new);

    public StringCurtain() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).lightLevel(blockState -> 1).noOcclusion().sound(SoundType.WOOL).strength(0.3f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    }

    public StringCurtain(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true))).setValue((Property)CENTER, (Comparable)Boolean.valueOf(true))).setValue((Property)IS_END, (Comparable)Boolean.valueOf(true))).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<? extends StringCurtain> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{ATTACHED, CENTER, IS_END, HORIZONTAL_FACING});
    }

    protected Map<Pair<Direction, Boolean>, VoxelShape> makeShapes() {
        Object2ObjectArrayMap shapeMap = new Object2ObjectArrayMap();
        shapeMap.put(Pair.of((Object)Direction.NORTH, (Object)false), Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
        shapeMap.put(Pair.of((Object)Direction.SOUTH, (Object)false), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
        shapeMap.put(Pair.of((Object)Direction.WEST, (Object)false), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        shapeMap.put(Pair.of((Object)Direction.EAST, (Object)false), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
        VoxelShape temp = Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        shapeMap.put(Pair.of((Object)Direction.NORTH, (Object)true), temp);
        shapeMap.put(Pair.of((Object)Direction.SOUTH, (Object)true), temp);
        temp = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
        shapeMap.put(Pair.of((Object)Direction.WEST, (Object)true), temp);
        shapeMap.put(Pair.of((Object)Direction.EAST, (Object)true), temp);
        return shapeMap;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.collisionShapeByMap.get(Pair.of((Object)((Direction)blockState.getValue((Property)HORIZONTAL_FACING)), (Object)((Boolean)blockState.getValue((Property)CENTER))));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ctx = (EntityCollisionContext)context;
            Entity entity = ctx.getEntity();
            if (entity == null) {
                return this.getShape(state, worldIn, pos, context);
            }
            if ((entity instanceof Bee || entity.getType().is(BzTags.STRING_CURTAIN_BLOCKS_PATHFINDING_FOR_NON_BEE_MOB)) && !entity.getType().is(BzTags.STRING_CURTAIN_FORCE_ALLOW_PATHFINDING) && state.is(BzTags.STRING_CURTAINS)) {
                return this.getShape(state, worldIn, pos, context);
            }
        }
        return Shapes.empty();
    }

    public VoxelShape getBlockSupportShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.empty();
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        boolean entityShouldBePushed = StringCurtain.shouldBlockOffEntity(entity);
        if (entityShouldBePushed && !entity.hasControllingPassenger() && !entity.isPassenger() && entity.isPushable() && blockState.is(BzTags.STRING_CURTAINS)) {
            Vec3 centerPos = blockState.getShape((BlockGetter)level, blockPos).bounds().getCenter().add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            Vec3 beeCenter = entity.position();
            double speedSlowdown = 1.4f;
            double forcePushSpeed = 0.03f;
            if (((Direction)blockState.getValue((Property)HORIZONTAL_FACING)).getAxis() == Direction.Axis.X) {
                if (centerPos.x() > beeCenter.x()) {
                    if (entity.getDeltaMovement().x() > 0.0) {
                        entity.setDeltaMovement(entity.getDeltaMovement().x() / speedSlowdown, entity.getDeltaMovement().y(), entity.getDeltaMovement().z());
                    }
                    entity.push(-forcePushSpeed, 0.0, 0.0);
                } else {
                    if (entity.getDeltaMovement().x() < 0.0) {
                        entity.setDeltaMovement(entity.getDeltaMovement().x() / speedSlowdown, entity.getDeltaMovement().y(), entity.getDeltaMovement().z());
                    }
                    entity.push(forcePushSpeed, 0.0, 0.0);
                }
            } else if (((Direction)blockState.getValue((Property)HORIZONTAL_FACING)).getAxis() == Direction.Axis.Z) {
                if (centerPos.z() > beeCenter.z()) {
                    if (entity.getDeltaMovement().z() > 0.0) {
                        entity.setDeltaMovement(entity.getDeltaMovement().x(), entity.getDeltaMovement().y(), entity.getDeltaMovement().z() / speedSlowdown);
                    }
                    entity.push(0.0, 0.0, -forcePushSpeed);
                } else {
                    if (entity.getDeltaMovement().z() < 0.0) {
                        entity.setDeltaMovement(entity.getDeltaMovement().x(), entity.getDeltaMovement().y(), entity.getDeltaMovement().z() / speedSlowdown);
                    }
                    entity.push(0.0, 0.0, forcePushSpeed);
                }
            }
        }
        super.entityInside(blockState, level, blockPos, entity);
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        BlockPos blockpos;
        Level level = placeContext.getLevel();
        BlockState clickedBlock = level.getBlockState(blockpos = placeContext.getClickedPos().relative(placeContext.getClickedFace().getOpposite()));
        if (!clickedBlock.isFaceSturdy((BlockGetter)level, blockpos, placeContext.getClickedFace())) {
            return null;
        }
        BlockState belowState = level.getBlockState(placeContext.getClickedPos().below());
        if (placeContext.getClickedFace().getAxis() != Direction.Axis.Y) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true))).setValue((Property)CENTER, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_END, (Comparable)Boolean.valueOf(!belowState.is(BzTags.STRING_CURTAINS)))).setValue((Property)HORIZONTAL_FACING, (Comparable)placeContext.getClickedFace());
        }
        if (placeContext.getClickedFace() == Direction.DOWN) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(true))).setValue((Property)CENTER, (Comparable)Boolean.valueOf(true))).setValue((Property)IS_END, (Comparable)Boolean.valueOf(!belowState.is(BzTags.STRING_CURTAINS)))).setValue((Property)HORIZONTAL_FACING, (Comparable)placeContext.getHorizontalDirection());
        }
        return null;
    }

    public boolean canSurvive(BlockState blockstate, LevelReader world, BlockPos pos) {
        if (!blockstate.is(BzTags.STRING_CURTAINS)) {
            return false;
        }
        if (((Boolean)blockstate.getValue((Property)CENTER)).booleanValue() || !((Boolean)blockstate.getValue((Property)ATTACHED)).booleanValue()) {
            BlockState aboveState = world.getBlockState(pos.above());
            return aboveState.is(BzTags.STRING_CURTAINS) && (Boolean)blockstate.getValue((Property)ATTACHED) == false || aboveState.isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN) && (Boolean)blockstate.getValue((Property)ATTACHED) != false;
        }
        Direction facing = (Direction)blockstate.getValue((Property)HORIZONTAL_FACING);
        BlockState sideState = world.getBlockState(pos.relative(facing.getOpposite()));
        BlockState aboveState = world.getBlockState(pos.above());
        return sideState.isFaceSturdy((BlockGetter)world, pos.relative(facing.getOpposite()), facing) || aboveState.isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN);
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        StringCurtain.blockUpdateCurtainChainUpward(level, blockPos);
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (!level.isClientSide) {
            BlockState belowState;
            boolean belowCurtain;
            if (!blockState.canSurvive((LevelReader)level, blockPos)) {
                level.destroyBlock(blockPos, true);
            }
            if ((belowCurtain = (belowState = level.getBlockState(blockPos.below())).is(BzTags.STRING_CURTAINS)) == (Boolean)blockState.getValue((Property)IS_END)) {
                boolean showEnds = !belowCurtain || belowState.getValue((Property)CENTER) != blockState.getValue((Property)CENTER) || belowState.getValue((Property)HORIZONTAL_FACING) != blockState.getValue((Property)HORIZONTAL_FACING);
                level.setBlock(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ATTACHED, (Comparable)((Boolean)blockState.getValue((Property)ATTACHED)))).setValue((Property)CENTER, (Comparable)((Boolean)blockState.getValue((Property)CENTER)))).setValue((Property)IS_END, (Comparable)Boolean.valueOf(showEnds))).setValue((Property)HORIZONTAL_FACING, (Comparable)((Direction)blockState.getValue((Property)HORIZONTAL_FACING))), 3);
            }
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockstate, Level world, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        if (blockstate.is(BzTags.STRING_CURTAINS)) {
            if (itemStack.is(BzTags.STRING_CURTAINS_CURTAIN_EXTENDING_ITEMS) && GeneralUtils.isPermissionAllowedAtSpot(world, (Entity)playerEntity, position, true)) {
                boolean success = StringCurtain.extendCurtainIfPossible(blockstate, world, position);
                if (success) {
                    if (!itemStack.isEmpty()) {
                        playerEntity.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                    }
                    if (!playerEntity.getAbilities().instabuild) {
                        itemStack.shrink(1);
                    }
                    if (playerEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                        ((GenericTrigger)((Object)BzCriterias.EXTEND_STRING_CURTAIN_TRIGGER.get())).trigger(serverPlayer);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (itemStack.is(BzTags.STRING_CURTAINS_ITEMS)) {
                playerEntity.displayClientMessage((Component)Component.translatable((String)"block.the_bumblezone.string_curtain.extending_clarification").withStyle(ChatFormatting.WHITE), true);
                return ItemInteractionResult.FAIL;
            }
        }
        return super.useItemOn(itemStack, blockstate, world, position, playerEntity, playerHand, raytraceResult);
    }

    public static InteractionResult onBlockInteractEvent(BzPlayerItemUseOnBlockEvent event) {
        Player player = event.user();
        InteractionHand interactionHand = event.hand();
        ItemStack heldItem = player.getItemInHand(interactionHand);
        if (player != null && heldItem.is(BzTags.STRING_CURTAINS_CURTAIN_EXTENDING_ITEMS)) {
            ItemInteractionResult interactionResult;
            BlockHitResult hitResult = event.hitResult();
            BlockState clickedState = event.level().getBlockState(hitResult.getBlockPos());
            if (clickedState.is(BzTags.STRING_CURTAINS)) {
                return null;
            }
            BlockPos pos = hitResult.getBlockPos().relative(hitResult.getDirection()).above();
            BlockState aboveState = player.level().getBlockState(pos);
            if (aboveState.is(BzTags.STRING_CURTAINS) && (interactionResult = aboveState.useItemOn(heldItem, player.level(), player, interactionHand, new BlockHitResult(hitResult.getLocation().add(0.0, 1.0, 0.0), hitResult.getDirection(), pos, hitResult.isInside()))) != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
                return InteractionResult.SUCCESS;
            }
        }
        return null;
    }

    public static boolean extendCurtainIfPossible(BlockState blockstate, Level world, BlockPos position) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)position);
        BlockState belowState = world.getBlockState((BlockPos)mutableBlockPos.move(Direction.DOWN));
        while (belowState.is(BzTags.STRING_CURTAINS) && world.isInWorldBounds((BlockPos)mutableBlockPos)) {
            belowState = world.getBlockState((BlockPos)mutableBlockPos.move(Direction.DOWN));
        }
        if (world.isInWorldBounds((BlockPos)mutableBlockPos) && belowState.isAir()) {
            world.setBlock((BlockPos)mutableBlockPos, (BlockState)((BlockState)((BlockState)blockstate.getBlock().defaultBlockState().setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)CENTER, (Comparable)((Boolean)blockstate.getValue((Property)CENTER)))).setValue((Property)HORIZONTAL_FACING, (Comparable)((Direction)blockstate.getValue((Property)HORIZONTAL_FACING))), 3);
            StringCurtain.blockUpdateCurtainChainUpward(world, (BlockPos)mutableBlockPos);
            return true;
        }
        return false;
    }

    private static void blockUpdateCurtainChainUpward(Level world, BlockPos position) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)position);
        BlockState aboveState = world.getBlockState((BlockPos)mutableBlockPos.move(Direction.UP));
        while (aboveState.is(BzTags.STRING_CURTAINS) && world.isInWorldBounds((BlockPos)mutableBlockPos)) {
            world.blockUpdated((BlockPos)mutableBlockPos, aboveState.getBlock());
            mutableBlockPos.move(Direction.UP);
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int comparatorPower;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        BlockState currentState = level.getBlockState((BlockPos)mutableBlockPos.move(Direction.DOWN));
        for (comparatorPower = 0; currentState.is(BzTags.STRING_CURTAINS) && comparatorPower < 15; ++comparatorPower) {
            currentState = level.getBlockState((BlockPos)mutableBlockPos.move(Direction.DOWN));
        }
        return comparatorPower;
    }

    @Nullable
    public static PathType getCurtainBlockPathType(Entity mob, PathfindingContext pathfindingContext, BlockPos blockPos, PathType blockPathType) {
        boolean shouldBlockPathfinding;
        if (blockPathType == PathType.OPEN && mob != null && (shouldBlockPathfinding = StringCurtain.shouldBlockOffEntity(mob)) && pathfindingContext.getBlockState(blockPos).is(BzTags.STRING_CURTAINS)) {
            return PathType.BLOCKED;
        }
        return null;
    }

    public static boolean shouldBlockOffEntity(Entity mob) {
        boolean shouldBlockPathfinding;
        boolean bl = shouldBlockPathfinding = (mob instanceof Bee || mob.getType().is(BzTags.STRING_CURTAIN_BLOCKS_PATHFINDING_FOR_NON_BEE_MOB)) && !mob.getType().is(BzTags.STRING_CURTAIN_FORCE_ALLOW_PATHFINDING);
        if (!shouldBlockPathfinding && !ModChecker.HOST_BEE_COMPATS.isEmpty()) {
            for (ModCompat compat : ModChecker.HOST_BEE_COMPATS) {
                if (!compat.isHostBee(mob)) continue;
                shouldBlockPathfinding = true;
                break;
            }
        }
        return shouldBlockPathfinding;
    }
}

