/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.armor;

import com.telepathicgrunt.the_bumblezone.client.armor.ArmorModelProvider;
import com.telepathicgrunt.the_bumblezone.client.rendering.armor.BeeArmorModel;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BeeArmorModelProvider
implements ArmorModelProvider {
    private BeeArmorModel model;
    private int variant;

    @Override
    public ResourceLocation getArmorTexture(Entity entity, ItemStack stack, EquipmentSlot slot, ArmorMaterial.Layer type) {
        BeeArmor beeArmor;
        Item item = stack.getItem();
        if (item instanceof BeeArmor && (beeArmor = (BeeArmor)item).hasTransTexture()) {
            return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)("textures/models/armor/trans_bee_material_layer_" + this.variant + ".png"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)("textures/models/armor/bee_material_layer_" + this.variant + ".png"));
    }

    @Override
    @NotNull
    public HumanoidModel<?> getModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
        BeeArmor beeArmor;
        Item item;
        if (this.model == null || (item = stack.getItem()) instanceof BeeArmor && this.variant != (beeArmor = (BeeArmor)item).getVariant()) {
            ModelPart layer = null;
            Item item2 = stack.getItem();
            if (item2 instanceof BeeArmor) {
                BeeArmor beeArmor2 = (BeeArmor)item2;
                int newVariant = beeArmor2.getVariant();
                if (newVariant == 1) {
                    layer = Minecraft.getInstance().getEntityModels().bakeLayer(BeeArmorModel.VARIANT_1_LAYER_LOCATION);
                } else if (newVariant == 2) {
                    layer = Minecraft.getInstance().getEntityModels().bakeLayer(BeeArmorModel.VARIANT_2_LAYER_LOCATION);
                }
                this.variant = newVariant;
            }
            if (layer == null) {
                layer = Minecraft.getInstance().getEntityModels().bakeLayer(BeeArmorModel.VARIANT_1_LAYER_LOCATION);
            }
            this.model = new BeeArmorModel(layer, slot, entity);
        }
        this.model.entityLiving = entity;
        return this.model;
    }
}

