/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.essence;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.items.essence.KnowingEssence;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector4d;

public class KnowingEssenceLootBlockOutlining {
    private static final double DRAW_RADIUS = 0.45;
    private static final double MIN_CORNER = 0.04999999999999999;
    private static final double MAX_CORNER = 0.95;
    private static final Vector4d VECTOR_4D_MIN = new Vector4d(0.04999999999999999, 0.04999999999999999, 0.04999999999999999, 1.0);
    private static final Vector4d VECTOR_4D_MAX = new Vector4d(0.95, 0.95, 0.95, 1.0);
    private static final LinkedHashSet<Long> CACHED_CHUNK_POS = new LinkedHashSet();
    private static final Long2ObjectOpenHashMap<CachedChunkData> CACHED_CHUNK_DATA = new Long2ObjectOpenHashMap();
    private static final Set<Block> CACHED_TARGET_BLOCKS = new ObjectOpenHashSet();
    private static final Set<Block> CACHED_NONTARGET_BLOCKS = new ObjectOpenHashSet();
    private static final int chunkRadius = 4;
    private static final int chunksToCheck = 81;
    private static final int chunkPerBatch = 3;
    private static final int chunkBatches = 27;
    private static final long scanAllChunkTimeframe = 1000L;
    private static final long targetScanTimeIncrement = 37L;
    private static long targetScanTime = 0L;
    private static long currentScanIncrement = 0L;

    public static void resetTargetBlockCache() {
        CACHED_TARGET_BLOCKS.clear();
        CACHED_NONTARGET_BLOCKS.clear();
    }

    public static void outlineLootBlocks(PoseStack poseStack, Camera camera, LevelRenderer levelRenderer) {
        Player player = GeneralUtilsClient.getClientPlayer();
        if (KnowingEssence.IsKnowingEssenceActive(player)) {
            Level level = player.level();
            Vec3 cameraPos = camera.getPosition();
            KnowingEssenceLootBlockOutlining.scanChunks(cameraPos, level);
            KnowingEssenceLootBlockOutlining.drawOutlines(poseStack, cameraPos);
        } else if (!CACHED_CHUNK_POS.isEmpty()) {
            CACHED_CHUNK_DATA.clear();
            CACHED_CHUNK_POS.clear();
        }
    }

    private static void scanChunks(Vec3 cameraPos, Level level) {
        long currentTime = System.currentTimeMillis();
        if (currentTime > targetScanTime) {
            targetScanTime = currentTime + 37L;
            BlockPos worldSpot = BlockPos.containing((Position)cameraPos);
            ChunkPos centerChunkPos = new ChunkPos(worldSpot);
            int currentChunk = 0;
            HashSet<Long> copySet = new HashSet<Long>(CACHED_CHUNK_POS);
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    long chunkPosLong = ChunkPos.asLong((int)(x + centerChunkPos.x), (int)(z + centerChunkPos.z));
                    copySet.remove(chunkPosLong);
                    if ((long)(++currentChunk) <= 3L * currentScanIncrement || (long)currentChunk > 3L * (currentScanIncrement + 1L)) continue;
                    LevelChunk chunk = level.getChunk(x + centerChunkPos.x, z + centerChunkPos.z);
                    CACHED_CHUNK_DATA.put(chunkPosLong, (Object)new CachedChunkData((List<CachedDrawData>)new ObjectArrayList()));
                    CACHED_CHUNK_POS.add(chunkPosLong);
                    KnowingEssenceLootBlockOutlining.blockEntityScan(chunk, chunkPosLong);
                    KnowingEssenceLootBlockOutlining.blockScan(chunk, chunkPosLong);
                }
            }
            for (Long chunkPos : copySet) {
                CACHED_CHUNK_POS.remove(chunkPos);
                CACHED_CHUNK_DATA.remove(chunkPos.longValue());
            }
            if (++currentScanIncrement >= 27L) {
                currentScanIncrement = 0L;
            }
        }
    }

    private static void blockEntityScan(LevelChunk chunk, long chunkPosLong) {
        for (Map.Entry blockEntityEntry : chunk.getBlockEntities().entrySet()) {
            BlockEntity blockEntity = (BlockEntity)blockEntityEntry.getValue();
            BlockState blockState = blockEntity.getBlockState();
            Block block = blockState.getBlock();
            if (CACHED_NONTARGET_BLOCKS.contains(block)) continue;
            if (CACHED_TARGET_BLOCKS.contains(block) || (blockState.is(BzTags.KNOWING_BLOCK_ENTITY_FORCED_HIGHLIGHTING) || blockEntity instanceof RandomizableContainerBlockEntity || blockEntity instanceof BrushableBlockEntity || blockEntity instanceof EnderChestBlockEntity || blockEntity instanceof DecoratedPotBlockEntity || block instanceof EnderChestBlock) && !blockState.is(BzTags.KNOWING_BLOCK_ENTITY_PREVENT_HIGHLIGHTING)) {
                CACHED_TARGET_BLOCKS.add(block);
                BlockPos lootBlockPos = (BlockPos)blockEntityEntry.getKey();
                int colorInt = block.defaultMapColor().col;
                int red = FastColor.ARGB32.red((int)colorInt);
                int green = FastColor.ARGB32.green((int)colorInt);
                int blue = FastColor.ARGB32.blue((int)colorInt);
                ((CachedChunkData)KnowingEssenceLootBlockOutlining.CACHED_CHUNK_DATA.get((long)chunkPosLong)).cachedDrawData.add(new CachedDrawData(VECTOR_4D_MIN.x() + (double)lootBlockPos.getX(), VECTOR_4D_MIN.y() + (double)lootBlockPos.getY(), VECTOR_4D_MIN.z() + (double)lootBlockPos.getZ(), VECTOR_4D_MAX.x() + (double)lootBlockPos.getX(), VECTOR_4D_MAX.y() + (double)lootBlockPos.getY(), VECTOR_4D_MAX.z() + (double)lootBlockPos.getZ(), red, green, blue));
                continue;
            }
            CACHED_NONTARGET_BLOCKS.add(block);
        }
    }

    private static void blockScan(LevelChunk chunk, long chunkPosLong) {
        for (int i = 0; i < chunk.getSectionsCount(); ++i) {
            LevelChunkSection levelChunkSection = chunk.getSection(i);
            if (levelChunkSection.hasOnlyAir() || !levelChunkSection.maybeHas(blockState -> !CACHED_NONTARGET_BLOCKS.contains(blockState.getBlock()) && (CACHED_TARGET_BLOCKS.contains(blockState.getBlock()) || blockState.is(BzTags.KNOWING_BLOCK_FORCED_HIGHLIGHTING) || blockState.getBlock() instanceof InfestedBlock && !blockState.is(BzTags.KNOWING_BLOCK_PREVENT_HIGHLIGHTING)))) continue;
            int minSectionY = chunk.getMinBuildHeight() + i * 16;
            for (int sectionX = 0; sectionX < 16; ++sectionX) {
                for (int sectionZ = 0; sectionZ < 16; ++sectionZ) {
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        BlockState blockState2 = levelChunkSection.getBlockState(sectionX, sectionY, sectionZ);
                        Block block = blockState2.getBlock();
                        if (CACHED_NONTARGET_BLOCKS.contains(block)) continue;
                        if (CACHED_TARGET_BLOCKS.contains(blockState2.getBlock()) || blockState2.is(BzTags.KNOWING_BLOCK_FORCED_HIGHLIGHTING) || blockState2.getBlock() instanceof InfestedBlock && !blockState2.is(BzTags.KNOWING_BLOCK_PREVENT_HIGHLIGHTING)) {
                            CACHED_TARGET_BLOCKS.add(block);
                            BlockPos lootBlockPos = new BlockPos(sectionX + (chunk.getPos().x << 4), minSectionY + sectionY, sectionZ + (chunk.getPos().z << 4));
                            int colorInt = block.defaultMapColor().col;
                            int red = FastColor.ARGB32.red((int)colorInt);
                            int green = FastColor.ARGB32.green((int)colorInt);
                            int blue = FastColor.ARGB32.blue((int)colorInt);
                            ((CachedChunkData)KnowingEssenceLootBlockOutlining.CACHED_CHUNK_DATA.get((long)chunkPosLong)).cachedDrawData.add(new CachedDrawData(VECTOR_4D_MIN.x() + (double)lootBlockPos.getX(), VECTOR_4D_MIN.y() + (double)lootBlockPos.getY(), VECTOR_4D_MIN.z() + (double)lootBlockPos.getZ(), VECTOR_4D_MAX.x() + (double)lootBlockPos.getX(), VECTOR_4D_MAX.y() + (double)lootBlockPos.getY(), VECTOR_4D_MAX.z() + (double)lootBlockPos.getZ(), red, green, blue));
                            continue;
                        }
                        CACHED_NONTARGET_BLOCKS.add(block);
                    }
                }
            }
        }
    }

    private static void drawOutlines(PoseStack poseStack, Vec3 cameraPos) {
        if (!CACHED_CHUNK_DATA.isEmpty()) {
            boolean hasEntry = false;
            for (CachedChunkData cachedChunkData2 : CACHED_CHUNK_DATA.values()) {
                if (cachedChunkData2.cachedDrawData.isEmpty()) continue;
                hasEntry = true;
                break;
            }
            if (!hasEntry) {
                return;
            }
            poseStack.pushPose();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.disableDepthTest();
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f lastPose = poseStack.last().pose();
            CACHED_CHUNK_DATA.values().forEach(cachedChunkData -> cachedChunkData.cachedDrawData.forEach(cachedDrawData -> KnowingEssenceLootBlockOutlining.renderLineBox(bufferbuilder, lastPose, (float)(cachedDrawData.minX - cameraPos.x()), (float)(cachedDrawData.minY - cameraPos.y()), (float)(cachedDrawData.minZ - cameraPos.z()), (float)(cachedDrawData.maxX - cameraPos.x()), (float)(cachedDrawData.maxY - cameraPos.y()), (float)(cachedDrawData.maxZ - cameraPos.z()), cachedDrawData.red, cachedDrawData.green, cachedDrawData.blue)));
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            poseStack.popPose();
            RenderSystem.enableDepthTest();
            RenderType.cutout().clearRenderState();
        }
    }

    private static void renderLineBox(BufferBuilder builder, Matrix4f pose, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int red, int green, int blue) {
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, 255).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, 255).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, 255).setNormal(-1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, 255).setNormal(-1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, minX, maxY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, -1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, -1.0f, 0.0f);
        builder.addVertex(pose, minX, minY, maxZ).setColor(red, green, blue, 255).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, 255).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(pose, maxX, minY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, -1.0f);
        builder.addVertex(pose, minX, maxY, maxZ).setColor(red, green, blue, 255).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, 255).setNormal(1.0f, 0.0f, 0.0f);
        builder.addVertex(pose, maxX, minY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(pose, maxX, maxY, minZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, 1.0f);
        builder.addVertex(pose, maxX, maxY, maxZ).setColor(red, green, blue, 255).setNormal(0.0f, 0.0f, 1.0f);
    }

    private record CachedChunkData(List<CachedDrawData> cachedDrawData) {
    }

    private record CachedDrawData(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int red, int green, int blue) {
    }
}

