/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;

public class BzMusicDiscsDownloadLinkTooltip {
    private static final Map<ResourceKey<JukeboxSong>, String> SONG_WITH_DOWNLOAD_LINKS = new HashMap<ResourceKey<JukeboxSong>, String>();

    public static void SetupTooltipData() {
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_HONEY_BEE_RAT_FACED_BOY.get());
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_RIVERS_OF_HONEY_MOSERAO.get());
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_LA_BEE_DA_LOCA.get());
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_BEE_LAXING_WITH_THE_HOM_BEES.get());
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_BEE_WARE_OF_THE_TEMPLE.get());
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_A_LAST_FIRST_LAST.get());
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_DROWNING_IN_DESPAIR.get());
        BzMusicDiscsDownloadLinkTooltip.AddSong((Item)BzItems.MUSIC_DISC_BEENNA_BOX.get());
    }

    public static void AddSong(Item item) {
        JukeboxPlayable jukeboxPlayable = (JukeboxPlayable)item.components().get(DataComponents.JUKEBOX_PLAYABLE);
        if (jukeboxPlayable != null) {
            SONG_WITH_DOWNLOAD_LINKS.put((ResourceKey<JukeboxSong>)jukeboxPlayable.song().key(), item.getDescriptionId() + ".download");
        } else {
            Bumblezone.LOGGER.error("Unable to setup song download link data for {}", (Object)item);
        }
    }

    public static void appendDownloadLinkText(JukeboxPlayable jukeboxPlayable, Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        if (jukeboxPlayable.showInTooltip() && SONG_WITH_DOWNLOAD_LINKS.containsKey(jukeboxPlayable.song().key()) && tooltipContext.registries() != null) {
            Optional<Integer> songDescLength = jukeboxPlayable.song().unwrap(tooltipContext.registries()).map(holder -> ((JukeboxSong)holder.value()).description().getString().length());
            int length = songDescLength.orElse(20);
            List<MutableComponent> componentList = GeneralUtilsClient.autoWrappedTooltip(length, SONG_WITH_DOWNLOAD_LINKS.get(jukeboxPlayable.song().key()));
            componentList.forEach(component -> consumer.accept((Component)component.withStyle(tooltipFlag.isAdvanced() ? ChatFormatting.DARK_PURPLE : ChatFormatting.DARK_GRAY)));
        }
    }
}

