/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.potions;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import org.jetbrains.annotations.Nullable;

public class ConfigSafePotion
extends Potion {
    private final Supplier<List<MobEffectInstance>> effectListCreator;
    private List<MobEffectInstance> cachedEffectList = null;

    public ConfigSafePotion(Supplier<List<MobEffectInstance>> mobEffectInstancesSupplier) {
        this(null, mobEffectInstancesSupplier);
    }

    public ConfigSafePotion(@Nullable String string, Supplier<List<MobEffectInstance>> mobEffectInstancesSupplier) {
        super(string, new MobEffectInstance[0]);
        this.effectListCreator = mobEffectInstancesSupplier;
    }

    public List<MobEffectInstance> getEffects() {
        return this.getCachedEffectList();
    }

    public boolean hasInstantEffects() {
        if (!this.getCachedEffectList().isEmpty()) {
            for (MobEffectInstance mobEffectInstance : this.getCachedEffectList()) {
                if (!((MobEffect)mobEffectInstance.getEffect().value()).isInstantenous()) continue;
                return true;
            }
        }
        return false;
    }

    public List<MobEffectInstance> getCachedEffectList() {
        if (this.cachedEffectList == null) {
            this.cachedEffectList = this.effectListCreator.get();
        }
        return this.cachedEffectList;
    }

    public void clearCachedEffectList() {
        this.cachedEffectList = null;
    }
}

