/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.loot;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.loot.EntityLootDropInterface;
import com.telepathicgrunt.the_bumblezone.loot.LootParamsBzVisitedLootInterface;
import com.telepathicgrunt.the_bumblezone.mixin.loot.LootContextAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public final class NewLootInjectorApplier {
    public static final ResourceKey<LootTable> VANILLA_FISHING_LOOT_TABLE_RK = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"gameplay/fishing"));
    public static final ResourceLocation BZ_DIMENSION_FISHING_LOOT_TABLE_RL = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"gameplay/fishing");
    public static final ResourceLocation STINGER_DROP_LOOT_TABLE_RL = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"entities/bee_stinger_drops");

    private NewLootInjectorApplier() {
    }

    public static boolean checkIfInjectBeeStingerLoot(LootContext context) {
        Object object;
        if ((BzGeneralConfigs.beeLootInjection || BzGeneralConfigs.moddedBeeLootInjection) && context.hasParam(LootContextParams.THIS_ENTITY) && (object = context.getParam(LootContextParams.THIS_ENTITY)) instanceof Bee) {
            Bee bee = (Bee)object;
            if (!((LootParamsBzVisitedLootInterface)((LootContextAccessor)context).bumblezone$getParams()).getVisitedBzVisitedLootRL().contains(STINGER_DROP_LOOT_TABLE_RL) && !((EntityLootDropInterface)bee).thebumblezone_hasPerformedEntityDrops()) {
                ResourceLocation beeRL = BuiltInRegistries.ENTITY_TYPE.getKey((Object)bee.getType());
                return BzGeneralConfigs.beeLootInjection && beeRL.getNamespace().equals("minecraft") || BzGeneralConfigs.moddedBeeLootInjection && !beeRL.getNamespace().equals("minecraft");
            }
        }
        return false;
    }

    public static boolean checkIfValidForDimensionFishingLoot(LootContext context) {
        if (!((LootParamsBzVisitedLootInterface)((LootContextAccessor)context).bumblezone$getParams()).getVisitedBzVisitedLootRL().contains(BZ_DIMENSION_FISHING_LOOT_TABLE_RL)) {
            return context.getLevel().dimension().equals(BzDimension.BZ_WORLD_KEY);
        }
        return false;
    }

    public static void injectLoot(LootContext context, List<ItemStack> originalLoot, ResourceLocation lootTableToPullFrom) {
        Entity entity;
        Optional optionalLootTableReference = context.getResolver().get(Registries.LOOT_TABLE, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableToPullFrom));
        if (optionalLootTableReference.isEmpty()) {
            return;
        }
        LootTable stingerLootTable = (LootTable)((Holder.Reference)optionalLootTableReference.get()).value();
        ((LootParamsBzVisitedLootInterface)((LootContextAccessor)context).bumblezone$getParams()).addVisitedBzVisitedLootRL(lootTableToPullFrom);
        ObjectArrayList newItems = new ObjectArrayList();
        stingerLootTable.getRandomItems(((LootContextAccessor)context).bumblezone$getParams(), arg_0 -> ((ObjectArrayList)newItems).add(arg_0));
        originalLoot.addAll((Collection<ItemStack>)newItems);
        if (context.hasParam(LootContextParams.THIS_ENTITY) && (entity = (Entity)context.getParam(LootContextParams.THIS_ENTITY)) != null) {
            ((EntityLootDropInterface)entity).thebumblezone_performedEntityDrops();
        }
    }
}

