/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.PotionCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakePotionCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.EMIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.EMIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.QueenRandomizerTradesEMICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi.QueenTradesEMICategory;
import com.telepathicgrunt.the_bumblezone.modinit.BzCreativeTabs;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

@EmiEntrypoint
public class EMICompat
implements EmiPlugin {
    public static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)BzItems.BEE_QUEEN_SPAWN_EGG.get()));
    public static final EmiRecipeCategory QUEEN_TRADES = new QueenTradesEMICategory();
    public static final EmiRecipeCategory QUEEN_RANDOMIZE_TRADES = new QueenRandomizerTradesEMICategory();

    public void register(EmiRegistry registry) {
        BzCreativeTabs.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> EMICompat.addInfo(registry, (Item)item.get()));
        EMICompat.addInfo(registry, (Fluid)BzFluids.SUGAR_WATER_FLUID.get());
        EMICompat.addInfo(registry, (Fluid)BzFluids.ROYAL_JELLY_FLUID.get());
        if (BzModCompatibilityConfigs.alternativeFluidToReplaceHoneyFluid.isEmpty()) {
            EMICompat.addInfo(registry, (Fluid)BzFluids.HONEY_FLUID.get());
        }
        registry.getRecipeManager().byKey(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"potion_candle/from_super_candles")).ifPresent(recipe -> EMICompat.registerExtraRecipes(recipe, registry, true));
        registry.getRecipeManager().byKey(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"potion_candle/from_string_and_carvable_wax")).ifPresent(recipe -> EMICompat.registerExtraRecipes(recipe, registry, false));
        registry.addCategory(QUEEN_TRADES);
        registry.addCategory(QUEEN_RANDOMIZE_TRADES);
        registry.addWorkstation(QUEEN_TRADES, (EmiIngredient)WORKSTATION);
        registry.addWorkstation(QUEEN_RANDOMIZE_TRADES, (EmiIngredient)WORKSTATION);
        long recipeId = 1L;
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((WeightedRandomList)trade.getSecond()).unwrap()) {
                    List<EmiStack> rewardCollection = weightedTradeResult.getItems().stream().map(EmiStack::of).toList();
                    registry.addRecipe((EmiRecipe)new EMIQueenTradesInfo(EmiIngredient.of((Ingredient)(((MainTradeRowInput)trade.getFirst()).tagKey().isPresent() ? Ingredient.of(((MainTradeRowInput)trade.getFirst()).tagKey().get()) : Ingredient.of((ItemLike[])new ItemLike[]{((MainTradeRowInput)trade.getFirst()).item()}))), (TagKey<Item>)((TagKey)((MainTradeRowInput)trade.getFirst()).tagKey().orElse(null)), rewardCollection, (TagKey<Item>)((TagKey)weightedTradeResult.tagKey.orElse(null)), weightedTradeResult.xpReward, weightedTradeResult.weight, weightedTradeResult.getTotalWeight(), ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)("" + recipeId))));
                    ++recipeId;
                }
            }
        }
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            Object2ObjectOpenHashMap cacheEmiData = new Object2ObjectOpenHashMap();
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                TagKey<Item> itemTagKey = tradeEntry.tagKey().get();
                TagData tagData = cacheEmiData.getOrDefault(itemTagKey, null);
                if (tagData == null) {
                    List<ItemStack> randomizeStack = tradeEntry.getWantItems().stream().map(e -> ((Item)e.value()).getDefaultInstance()).toList();
                    List<EmiStack> emiStackList = randomizeStack.stream().map(EmiStack::of).collect(Collectors.toList());
                    EmiIngredient emiIngredient = EmiIngredient.of(itemTagKey);
                    tagData = new TagData(randomizeStack.size(), emiStackList, emiIngredient);
                    cacheEmiData.put(itemTagKey, tagData);
                }
                registry.addRecipe((EmiRecipe)new EMIQueenRandomizerTradesInfo(EmiIngredient.of((Ingredient)Ingredient.of(itemTagKey)), true, tagData.emiStack(), itemTagKey, tagData.emiIngredient(), 1, tagData.listSize(), ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)("" + recipeId))));
                ++recipeId;
            }
        }
        List<ItemStack> hangingGardensFlowers = GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_FLOWERS_BLOCKS);
        hangingGardensFlowers.addAll(GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_TALL_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_TALL_FLOWERS_BLOCKS));
        EMICompat.addComplexBlockTagInfo(registry, Pair.of((Object)".hanging_gardens_flowers.description", hangingGardensFlowers), Pair.of((Object)".crystalline_flower_can_be_placed_on.description", GeneralUtils.convertBlockTagsToItemStacks(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON, null)));
    }

    @SafeVarargs
    private static void addComplexBlockTagInfo(@NotNull EmiRegistry registry, Pair<String, List<ItemStack>> ... structureInfo) {
        for (Pair<String, List<ItemStack>> predicatePair : structureInfo) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((Ingredient)Ingredient.of(((List)predicatePair.getSecond()).stream()))), List.of(Component.translatable((String)("the_bumblezone" + (String)predicatePair.getFirst()))), ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)((String)predicatePair.getFirst()))));
        }
    }

    private static void registerExtraRecipes(RecipeHolder<?> baseRecipe, EmiRegistry registry, boolean oneRecipeOnly) {
        Recipe recipe = baseRecipe.value();
        if (recipe instanceof PotionCandleRecipe) {
            PotionCandleRecipe potionCandleRecipe = (PotionCandleRecipe)recipe;
            List<CraftingRecipe> extraRecipes = FakePotionCandleRecipeCreator.constructFakeRecipes(potionCandleRecipe, oneRecipeOnly);
            for (int i = 0; i < extraRecipes.size(); ++i) {
                CraftingRecipe craftingRecipe = extraRecipes.get(i);
                registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(craftingRecipe.getIngredients().stream().map(EmiIngredient::of).toList(), EmiStack.of((ItemStack)craftingRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)), ResourceLocation.fromNamespaceAndPath((String)baseRecipe.id().getNamespace(), (String)(baseRecipe.id().getPath() + "_" + i)), false));
            }
        }
    }

    private static void addInfo(EmiRegistry registry, Item item) {
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)}))), List.of(Component.translatable((String)("the_bumblezone." + BuiltInRegistries.ITEM.getKey((Object)item).getPath() + ".description"))), ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)(BuiltInRegistries.ITEM.getKey((Object)item).getPath() + "_info"))));
    }

    private static void addInfo(EmiRegistry registry, Fluid fluid) {
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((Fluid)fluid)), List.of(Component.translatable((String)("the_bumblezone." + BuiltInRegistries.FLUID.getKey((Object)fluid).getPath() + ".description"))), ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)(BuiltInRegistries.FLUID.getKey((Object)fluid).getPath() + "_info"))));
    }

    record TagData(int listSize, List<EmiStack> emiStack, EmiIngredient emiIngredient) {
    }
}

