/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StrongerWaterloggingProcessor
extends StructureProcessor {
    public static final MapCodec<StrongerWaterloggingProcessor> CODEC = MapCodec.unit(StrongerWaterloggingProcessor::new);

    private StrongerWaterloggingProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (structureBlockInfoWorld.state().hasProperty((Property)BlockStateProperties.WATERLOGGED) && !((Boolean)structureBlockInfoWorld.state().getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.pos())) {
                return structureBlockInfoWorld;
            }
            ChunkAccess cachedChunk = levelReader.getChunk(structureBlockInfoWorld.pos());
            BlockPos worldPos = structureBlockInfoWorld.pos();
            BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                BlockState neighborState;
                if (Direction.DOWN == direction) continue;
                sidePos.set((Vec3i)worldPos).move(direction);
                if (cachedChunk.getPos().x != sidePos.getX() >> 4 || cachedChunk.getPos().z != sidePos.getZ() >> 4) {
                    cachedChunk = levelReader.getChunk((BlockPos)sidePos);
                }
                if (!(neighborState = cachedChunk.getBlockState((BlockPos)sidePos)).getFluidState().isSource()) continue;
                return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), (BlockState)structureBlockInfoWorld.state().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), structureBlockInfoWorld.nbt());
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.STRONGER_WATERLOGGING_PROCESSOR.get();
    }
}

