/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.groups;

import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.FTBEssentialsPlatform;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.commands.SimpleCommandPlayer;
import dev.ftb.mods.ftbessentials.commands.impl.cheat.SpeedCommand;
import dev.ftb.mods.ftbessentials.commands.impl.cheat.VirtualInventoryCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;

public class CheatCommands {
    public static final List<FTBCommand> COMMANDS = List.of(SimpleCommandPlayer.create("heal", 2, FTBEConfig.HEAL, (ctx, player) -> CheatCommands.heal(player)), SimpleCommandPlayer.create("feed", 2, FTBEConfig.FEED, (ctx, player) -> CheatCommands.feed(player)), SimpleCommandPlayer.create("extinguish", 2, FTBEConfig.EXTINGUISH, (ctx, player) -> CheatCommands.clearFire(player)), SimpleCommandPlayer.create("fly", 2, FTBEConfig.FLY, (ctx, player) -> CheatCommands.fly(player)), SimpleCommandPlayer.create("god", 2, FTBEConfig.GOD, (ctx, player) -> CheatCommands.god(player)), new SpeedCommand(), new VirtualInventoryCommand(), new SimpleCommandPlayer("enderchest", 0, 2, FTBEConfig.ENDER_CHEST, CheatCommands::enderChest));

    private static int enderChest(CommandContext<CommandSourceStack> ctx, ServerPlayer targetPlayer) {
        MutableComponent title = Component.translatable((String)"container.enderchest");
        ServerPlayer srcPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
        if (targetPlayer != null && srcPlayer != null) {
            if (!targetPlayer.getUUID().equals(srcPlayer.getUUID())) {
                title.append(" \u00d7 ").append(targetPlayer.getDisplayName());
            }
            srcPlayer.openMenu((MenuProvider)new SimpleMenuProvider((i, inv, p) -> ChestMenu.threeRows((int)i, (Inventory)inv, (Container)targetPlayer.getEnderChestInventory()), (Component)title));
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"ftbessentials.enderchest.unable"));
        return 0;
    }

    private static int clearFire(ServerPlayer player) {
        player.clearFire();
        return 1;
    }

    private static int feed(ServerPlayer player) {
        player.getFoodData().eat(40, 40.0f);
        return 1;
    }

    public static int heal(ServerPlayer targetPlayer) {
        targetPlayer.setHealth(targetPlayer.getMaxHealth());
        targetPlayer.getFoodData().eat(40, 40.0f);
        targetPlayer.clearFire();
        FTBEssentialsPlatform.curePotionEffects(targetPlayer);
        return 1;
    }

    private static int fly(ServerPlayer targetPlayer) {
        return FTBEPlayerData.getOrCreate((Player)targetPlayer).map(data -> {
            Abilities abilities = targetPlayer.getAbilities();
            if (data.canFly()) {
                data.setCanFly(false);
                if (targetPlayer.gameMode.isSurvival()) {
                    abilities.mayfly = false;
                    abilities.flying = false;
                }
                targetPlayer.displayClientMessage((Component)Component.translatable((String)"ftbessentials.flight.disabled"), true);
            } else {
                data.setCanFly(true);
                abilities.mayfly = true;
                targetPlayer.displayClientMessage((Component)Component.translatable((String)"ftbessentials.flight.enabled"), true);
            }
            targetPlayer.onUpdateAbilities();
            return 1;
        }).orElse(0);
    }

    private static int god(ServerPlayer targetPlayer) {
        return FTBEPlayerData.getOrCreate((Player)targetPlayer).map(data -> {
            Abilities abilities = targetPlayer.getAbilities();
            if (data.isGod()) {
                data.setGod(false);
                abilities.invulnerable = false;
                targetPlayer.displayClientMessage((Component)Component.translatable((String)"ftbessentials.god_mode.disabled"), true);
            } else {
                data.setGod(true);
                abilities.invulnerable = true;
                targetPlayer.displayClientMessage((Component)Component.translatable((String)"ftbessentials.god_mode.enabled"), true);
            }
            targetPlayer.onUpdateAbilities();
            return 1;
        }).orElse(0);
    }
}

