/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.chat;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class NicknameCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.NICK.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return Collections.singletonList((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nickname").requires((Predicate)FTBEConfig.NICK)).executes(context -> this.nickname(((CommandSourceStack)context.getSource()).getPlayerOrException(), ""))).then(Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.nickname(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"nickname")))));
    }

    public int nickname(ServerPlayer player, String nick) {
        if (nick.length() > 30) {
            player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.nick.too_long"), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setNick(nick.trim());
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getNick().isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.nick.reset"), false);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.nick.changed", (Object[])new Object[]{data.getNick()}), false);
            }
            data.sendTabName(player.server);
            return 1;
        }).orElse(0);
    }
}

