/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SearchPacket(ResourceLocation groupKey, List<ResourceLocation> structureKeys, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SearchPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"explorerscompass", (String)"search"));
    public static final StreamCodec<FriendlyByteBuf, SearchPacket> CODEC = StreamCodec.ofMember(SearchPacket::write, SearchPacket::read);

    public static SearchPacket read(FriendlyByteBuf buf) {
        ResourceLocation groupKey = buf.readResourceLocation();
        ArrayList<ResourceLocation> structureKeys = new ArrayList<ResourceLocation>();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            structureKeys.add(buf.readResourceLocation());
        }
        BlockPos pos = buf.readBlockPos();
        return new SearchPacket(groupKey, structureKeys, pos);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.groupKey);
        buf.writeInt(this.structureKeys.size());
        for (ResourceLocation key : this.structureKeys) {
            buf.writeResourceLocation(key);
        }
        buf.writeBlockPos(this.pos);
    }

    public static void handle(SearchPacket packet, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                ItemStack stack = ItemUtils.getHeldItem(context.player(), ExplorersCompass.explorersCompass);
                if (!stack.isEmpty()) {
                    ExplorersCompassItem explorersCompass = (ExplorersCompassItem)stack.getItem();
                    explorersCompass.searchForStructure((Level)((ServerLevel)context.player().level()), context.player(), packet.groupKey, packet.structureKeys, packet.pos, stack);
                }
            });
        }
    }

    public CustomPacketPayload.Type<SearchPacket> type() {
        return TYPE;
    }
}

