/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncPacket(boolean canTeleport, List<ResourceLocation> allowedStructureKeys, ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedStructureKeys, Map<ResourceLocation, ResourceLocation> structureKeysToTypeKeys, ListMultimap<ResourceLocation, ResourceLocation> typeKeysToStructureKeys) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"explorerscompass", (String)"sync"));
    public static final StreamCodec<FriendlyByteBuf, SyncPacket> CODEC = StreamCodec.ofMember(SyncPacket::write, SyncPacket::read);

    public static SyncPacket read(FriendlyByteBuf buf) {
        boolean canTeleport = buf.readBoolean();
        ArrayList<ResourceLocation> allowedStructureKeys = new ArrayList<ResourceLocation>();
        ArrayListMultimap dimensionKeysForAllowedStructureKeys = ArrayListMultimap.create();
        HashMap<ResourceLocation, ResourceLocation> structureKeysToTypeKeys = new HashMap<ResourceLocation, ResourceLocation>();
        ArrayListMultimap typeKeysToStructureKeys = ArrayListMultimap.create();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            ResourceLocation structureKey = buf.readResourceLocation();
            int numDimensions = buf.readInt();
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensions.add(buf.readResourceLocation());
            }
            ResourceLocation typeKey = buf.readResourceLocation();
            if (structureKey == null) continue;
            allowedStructureKeys.add(structureKey);
            dimensionKeysForAllowedStructureKeys.putAll((Object)structureKey, dimensions);
            structureKeysToTypeKeys.put(structureKey, typeKey);
        }
        int numTypes = buf.readInt();
        for (int i = 0; i < numTypes; ++i) {
            ResourceLocation typeKey = buf.readResourceLocation();
            int numStructuresToAdd = buf.readInt();
            for (int j = 0; j < numStructuresToAdd; ++j) {
                ResourceLocation structureKey = buf.readResourceLocation();
                typeKeysToStructureKeys.put((Object)typeKey, (Object)structureKey);
            }
        }
        return new SyncPacket(canTeleport, allowedStructureKeys, (ListMultimap<ResourceLocation, ResourceLocation>)dimensionKeysForAllowedStructureKeys, structureKeysToTypeKeys, (ListMultimap<ResourceLocation, ResourceLocation>)typeKeysToStructureKeys);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedStructureKeys.size());
        for (ResourceLocation structureKey : this.allowedStructureKeys) {
            buf.writeResourceLocation(structureKey);
            List dimensions = this.dimensionKeysForAllowedStructureKeys.get((Object)structureKey);
            buf.writeInt(dimensions.size());
            for (ResourceLocation dimensionKey : dimensions) {
                buf.writeResourceLocation(dimensionKey);
            }
            ResourceLocation typeKey = this.structureKeysToTypeKeys.get(structureKey);
            buf.writeResourceLocation(typeKey);
        }
        buf.writeInt(this.typeKeysToStructureKeys.keySet().size());
        for (ResourceLocation typeKey : this.typeKeysToStructureKeys.keySet()) {
            buf.writeResourceLocation(typeKey);
            List structureKeys = this.typeKeysToStructureKeys.get((Object)typeKey);
            buf.writeInt(structureKeys.size());
            for (ResourceLocation structureKey : structureKeys) {
                buf.writeResourceLocation(structureKey);
            }
        }
    }

    public static void handle(SyncPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                ExplorersCompass.canTeleport = packet.canTeleport;
                ExplorersCompass.allowedStructureKeys = packet.allowedStructureKeys;
                ExplorersCompass.dimensionKeysForAllowedStructureKeys = packet.dimensionKeysForAllowedStructureKeys;
                ExplorersCompass.structureKeysToTypeKeys = packet.structureKeysToTypeKeys;
                ExplorersCompass.typeKeysToStructureKeys = packet.typeKeysToStructureKeys;
            });
        }
    }

    public CustomPacketPayload.Type<SyncPacket> type() {
        return TYPE;
    }
}

