/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnit;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.powersink.IExternalPowerSink;
import com.google.common.primitives.Ints;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import gripe._90.arseng.definition.ArsEngConfig;

public record SourceEnergyAdaptor(IExternalPowerSink sink, IActionHost host) implements ISourceCap
{
    private static final double AE_PER_SOURCE = (Double)ArsEngConfig.AE_PER_SOURCE.get();

    public int getMaxReceive() {
        return this.getSourceCapacity();
    }

    public int getMaxExtract() {
        return 0;
    }

    public boolean canAcceptSource(int source) {
        return this.receiveSource(source, true) > 0;
    }

    public boolean canProvideSource(int source) {
        return false;
    }

    public int getSource() {
        return Ints.saturatedCast((long)((long)this.getSourceCapacity() - Math.round(this.sink.getExternalPowerDemand(PowerUnit.AE, (double)this.getSourceCapacity()) / AE_PER_SOURCE)));
    }

    public int getSourceCapacity() {
        IGridNode grid = this.host.getActionableNode();
        return grid != null ? (int)(grid.getGrid().getEnergyService().getMaxStoredPower() / AE_PER_SOURCE) : 0;
    }

    public int receiveSource(int source, boolean simulate) {
        this.sink.injectExternalPower(PowerUnit.AE, (double)source * AE_PER_SOURCE, Actionable.ofSimulate((boolean)simulate));
        return Math.min(source, this.getSourceCapacity() - this.getSource());
    }

    public int extractSource(int source, boolean simulate) {
        return 0;
    }

    public void setMaxSource(int max) {
        throw new UnsupportedOperationException();
    }

    public void setSource(int source) {
        throw new UnsupportedOperationException();
    }
}

