/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import mekanism.api.MekanismIMC;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.lib.Version;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorCache;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.content.fusion.FusionReactorCache;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.content.fusion.FusionReactorValidator;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.content.turbine.TurbineValidator;
import mekanism.generators.common.network.GeneratorsPacketHandler;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsBuilders;
import mekanism.generators.common.registries.GeneratorsChemicals;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.registries.GeneratorsCreativeTabs;
import mekanism.generators.common.registries.GeneratorsDataComponents;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.registries.GeneratorsItems;
import mekanism.generators.common.registries.GeneratorsModules;
import mekanism.generators.common.registries.GeneratorsSounds;
import mekanism.generators.common.registries.GeneratorsTileEntityTypes;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;

@Mod(value="mekanismgenerators")
public class MekanismGenerators
implements IModModule {
    public static final String MODID = "mekanismgenerators";
    public static MekanismGenerators instance;
    public final Version versionNumber;
    private final GeneratorsPacketHandler packetHandler;
    public static final MultiblockManager<TurbineMultiblockData> turbineManager;
    public static final MultiblockManager<FissionReactorMultiblockData> fissionReactorManager;
    public static final MultiblockManager<FusionReactorMultiblockData> fusionReactorManager;

    public MekanismGenerators(ModContainer modContainer, IEventBus modEventBus) {
        instance = this;
        Mekanism.addModule((IModModule)instance);
        this.versionNumber = new Version(modContainer);
        MekanismGeneratorsConfig.registerConfigs(modContainer);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(MekanismGeneratorsConfig::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        GeneratorsDataComponents.DATA_COMPONENTS.register(modEventBus);
        GeneratorsItems.ITEMS.register(modEventBus);
        GeneratorsBlocks.BLOCKS.register(modEventBus);
        GeneratorsFluids.FLUIDS.register(modEventBus);
        GeneratorsCreativeTabs.CREATIVE_TABS.register(modEventBus);
        GeneratorsSounds.SOUND_EVENTS.register(modEventBus);
        GeneratorsContainerTypes.CONTAINER_TYPES.register(modEventBus);
        GeneratorsTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        GeneratorsChemicals.CHEMICALS.register(modEventBus);
        GeneratorsModules.MODULES.register(modEventBus);
        this.packetHandler = new GeneratorsPacketHandler(modEventBus, this.versionNumber);
    }

    public static GeneratorsPacketHandler packetHandler() {
        return MekanismGenerators.instance.packetHandler;
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GeneratorsFluids.FLUIDS.registerBucketDispenserBehavior();
            BuildCommand.register((String)"turbine", (ILangEntry)GeneratorsLang.TURBINE, (StructureBuilder)new GeneratorsBuilders.TurbineBuilder());
            BuildCommand.register((String)"fission", (ILangEntry)GeneratorsLang.FISSION_REACTOR, (StructureBuilder)new GeneratorsBuilders.FissionReactorBuilder());
            BuildCommand.register((String)"fusion", (ILangEntry)GeneratorsLang.FUSION_REACTOR, (StructureBuilder)new GeneratorsBuilders.FusionReactorBuilder());
        });
        Mekanism.logger.info("Loaded 'Mekanism: Generators' module.");
    }

    private void imcQueue(InterModEnqueueEvent event) {
        MekanismIMC.addMekaSuitHelmetModules((Holder[])new Holder[]{GeneratorsModules.SOLAR_RECHARGING_UNIT});
        MekanismIMC.addMekaSuitPantsModules((Holder[])new Holder[]{GeneratorsModules.GEOTHERMAL_GENERATOR_UNIT});
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void resetClientDimensionChanged() {
        TurbineMultiblockData.clientRotationMap.clear();
    }

    static {
        turbineManager = new MultiblockManager("industrialTurbine", TurbineCache::new, TurbineValidator::new);
        fissionReactorManager = new MultiblockManager("fissionReactor", FissionReactorCache::new, FissionReactorValidator::new);
        fusionReactorManager = new MultiblockManager("fusionReactor", FusionReactorCache::new, FusionReactorValidator::new);
    }
}

