/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.infrastructure.data;

import java.util.concurrent.CompletableFuture;
import net.davio.aquaticambitions.infrastructure.data.loot.CAAGlobalLootModifierProvider;
import net.davio.aquaticambitions.infrastructure.data.recipe.CAARecipeProvider;
import net.davio.aquaticambitions.infrastructure.data.recipe.CAAStandardRecipeGen;
import net.davio.aquaticambitions.infrastructure.data.tags.CAARegistrateTags;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class CAADatagen {
    public static void gatherDataHighPriority(GatherDataEvent event) {
        if (event.getMods().contains("create_aquatic_ambitions")) {
            CAADatagen.addExtraRegistrateData();
        }
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new CAAStandardRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new CAAGlobalLootModifierProvider(output, lookupProvider));
        if (event.includeServer()) {
            CAARecipeProvider.registerAllProcessing(generator, output, lookupProvider);
        }
    }

    private static void addExtraRegistrateData() {
        CAARegistrateTags.addGenerators();
    }
}

