/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ILootrInfo {
    public LootrBlockType getInfoBlockType();

    public LootrInfoType getInfoType();

    @NotNull
    default public Vec3 getInfoVec() {
        return Vec3.atCenterOf((Vec3i)this.getInfoPos());
    }

    @NotNull
    public UUID getInfoUUID();

    public String getInfoKey();

    public static String generateInfoKey(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public boolean hasBeenOpened();

    public boolean isPhysicallyOpen();

    @NotNull
    public BlockPos getInfoPos();

    @Nullable
    public Component getInfoDisplayName();

    @NotNull
    public ResourceKey<Level> getInfoDimension();

    public int getInfoContainerSize();

    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory();

    public boolean isInfoReferenceInventory();

    @Nullable
    public ResourceKey<LootTable> getInfoLootTable();

    public long getInfoLootSeed();

    @Nullable
    default public Level getInfoLevel() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            return null;
        }
        return server.getLevel(this.getInfoDimension());
    }

    @Nullable
    default public Container getInfoContainer() {
        BlockEntity be;
        ServerLevel level;
        Level level2 = this.getInfoLevel();
        if (!(level2 instanceof ServerLevel) || (level = (ServerLevel)level2).isClientSide()) {
            return null;
        }
        if (this.getInfoType() == LootrInfoType.CONTAINER_ENTITY) {
            Entity entity = level.getEntity(this.getInfoUUID());
            if (entity instanceof Container) {
                Container container = (Container)entity;
                return container;
            }
        } else if (this.getInfoType() == LootrInfoType.CONTAINER_BLOCK_ENTITY && (be = level.getBlockEntity(this.getInfoPos())) instanceof Container) {
            Container container = (Container)be;
            return container;
        }
        return null;
    }

    default public NonNullList<ItemStack> buildInitialInventory() {
        return NonNullList.withSize((int)this.getInfoContainerSize(), (Object)ItemStack.EMPTY);
    }

    default public void saveInfoToTag(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("type", this.getInfoType().ordinal());
        tag.putInt("blockType", this.getInfoBlockType().ordinal());
        tag.put("position", NbtUtils.writeBlockPos((BlockPos)this.getInfoPos()));
        tag.putString("key", this.getInfoKey());
        tag.putString("dimension", this.getInfoDimension().location().toString());
        tag.putUUID("uuid", this.getInfoUUID());
        tag.putInt("size", this.getInfoContainerSize());
        if (this.getInfoLootTable() != null) {
            tag.putString("table", this.getInfoLootTable().location().toString());
            tag.putLong("seed", this.getInfoLootSeed());
        }
        if (this.getInfoDisplayName() != null) {
            tag.putString("name", Component.Serializer.toJson((Component)this.getInfoDisplayName(), (HolderLookup.Provider)provider));
        }
        if (this.isInfoReferenceInventory()) {
            tag.putInt("referenceSize", this.getInfoReferenceInventory().size());
            tag.put("reference", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.getInfoReferenceInventory(), (boolean)true, (HolderLookup.Provider)provider));
        }
    }

    public static ILootrInfo loadInfoFromTag(CompoundTag tag, HolderLookup.Provider provider) {
        LootrInfoType infoType = LootrInfoType.CONTAINER_BLOCK_ENTITY;
        if (tag.contains("type", 3)) {
            infoType = LootrInfoType.values()[tag.getInt("type")];
        } else if (tag.contains("entity") && tag.getBoolean("entity")) {
            infoType = LootrInfoType.CONTAINER_ENTITY;
        } else {
            LootrAPI.LOG.error("Couldn't deduce the infoType of LootrInfo from tag: {}", (Object)tag);
        }
        LootrBlockType blockType = null;
        if (tag.contains("blockType", 3)) {
            blockType = LootrBlockType.values()[tag.getInt("blockType")];
        }
        BlockPos pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"position").orElse(BlockPos.ZERO);
        UUID uuid = tag.getUUID("uuid");
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("dimension")));
        int size = tag.getInt("size");
        MutableComponent name = null;
        if (tag.contains("name")) {
            name = Component.Serializer.fromJson((String)tag.getString("name"), (HolderLookup.Provider)provider);
        }
        NonNullList reference = null;
        if (tag.contains("reference") && tag.contains("referenceSize")) {
            reference = NonNullList.withSize((int)tag.getInt("referenceSize"), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)tag.getCompound("reference"), (NonNullList)reference, (HolderLookup.Provider)provider);
            blockType = LootrBlockType.INVENTORY;
        }
        if (blockType == null) {
            blockType = infoType == LootrInfoType.CONTAINER_ENTITY ? LootrBlockType.ENTITY : LootrBlockType.CHEST;
        }
        ResourceKey table = null;
        long seed = -1L;
        if (tag.contains("table")) {
            table = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("table")));
            seed = tag.getLong("seed");
        }
        return new BaseLootrInfo(blockType, infoType, uuid, ILootrInfo.generateInfoKey(uuid), pos, (Component)name, (ResourceKey<Level>)dimension, size, (NonNullList<ItemStack>)reference, (ResourceKey<LootTable>)table, seed);
    }

    public static enum LootrInfoType {
        CONTAINER_BLOCK_ENTITY,
        CONTAINER_ENTITY;

    }
}

