/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.text_editor;

import ca.teamdman.sfm.client.text_editor.Caret;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;

public record Cursor(Caret tail, Caret head) {
    public Cursor(int position) {
        this(new Caret(position, 0), new Caret(position, 0));
    }

    @Override
    public String toString() {
        return "Cursor{tail=" + String.valueOf(this.tail) + ", head=" + String.valueOf(this.head) + "}";
    }

    public Cursor growSelectionLeft(Int2IntFunction lineLengths) {
        if (this.isHeadOnLeft()) {
            return new Cursor(this.tail(), this.head().moveLeftOneCharacter(lineLengths));
        }
        return new Cursor(this.tail().moveLeftOneCharacter(lineLengths), this.head());
    }

    public Cursor growSelectionRight(Int2IntFunction lineLengths, int numLines) {
        if (this.isHeadOnLeft()) {
            return new Cursor(this.tail(), this.head().moveRightOneCharacter(lineLengths, numLines));
        }
        return new Cursor(this.tail().moveRightOneCharacter(lineLengths, numLines), this.head());
    }

    public boolean isHeadOnLeft() {
        return this.head().compareTo(this.tail()) > 0;
    }

    public boolean hasSelection() {
        return !this.head().equals(this.tail());
    }

    public Caret getBeginning() {
        if (this.head().compareTo(this.tail()) <= 0) {
            return this.head();
        }
        return this.tail();
    }

    public Caret getEnd() {
        if (this.head().compareTo(this.tail()) <= 0) {
            return this.tail();
        }
        return this.head();
    }
}

