/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.blockentity.IFacadeBlockEntity;
import ca.teamdman.sfm.common.facade.FacadeData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public abstract class CommonFacadeBlockEntity
extends BlockEntity
implements IFacadeBlockEntity {
    @Nullable
    protected FacadeData facadeData = null;

    public CommonFacadeBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Override
    @Nullable
    public FacadeData getFacadeData() {
        return this.facadeData;
    }

    @Override
    public void updateFacadeData(FacadeData newFacadeData) {
        if (newFacadeData.equals(this.facadeData)) {
            return;
        }
        this.facadeData = newFacadeData;
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 8);
        }
        this.requestModelDataUpdate();
    }

    public abstract ModelData getModelData();

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        FacadeData tried = FacadeData.load(this.level, pTag);
        if (tried != null) {
            this.facadeData = tried;
            this.requestModelDataUpdate();
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag pTag = new CompoundTag();
        this.saveAdditional(pTag, pRegistries);
        return pTag;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (this.facadeData != null) {
            this.facadeData.save(pTag);
        }
    }
}

