/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.text_editor.SFMTextEditScreenDiskOpenContext;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundDiskItemSetProgramPacket;
import ca.teamdman.sfm.common.program.linting.ProgramLinter;
import ca.teamdman.sfm.common.registry.SFMDataComponents;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import ca.teamdman.sfm.common.util.SFMItemUtils;
import ca.teamdman.sfml.ast.Program;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskItem
extends Item {
    public DiskItem() {
        super(new Item.Properties());
    }

    public static String getProgram(ItemStack stack) {
        return (String)stack.getOrDefault(SFMDataComponents.PROGRAM_STRING, (Object)"");
    }

    public static void setProgram(ItemStack stack, String programString) {
        programString = programString.replaceAll("\r", "");
        stack.set(SFMDataComponents.PROGRAM_STRING, (Object)programString);
    }

    public static void pruneIfDefault(ItemStack stack) {
        if (DiskItem.getProgram(stack).isBlank() && LabelPositionHolder.from(stack).isEmpty()) {
            DiskItem.clearData(stack);
        }
    }

    public static void clearData(ItemStack stack) {
        stack.remove(SFMDataComponents.PROGRAM_STRING);
        stack.remove(SFMDataComponents.PROGRAM_ERRORS);
        stack.remove(SFMDataComponents.PROGRAM_WARNINGS);
        stack.remove(SFMDataComponents.LABEL_POSITION_HOLDER);
    }

    @Nullable
    public static Program compileAndUpdateErrorsAndWarnings(ItemStack stack, @Nullable ManagerBlockEntity manager) {
        if (manager != null) {
            manager.logger.info(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_FROM_DISK_BEGIN.get()));
        }
        AtomicReference<Object> rtn = new AtomicReference<Object>(null);
        Program.compile(DiskItem.getProgram(stack), successProgram -> {
            ArrayList<TranslatableContents> warnings = ProgramLinter.gatherWarnings(successProgram, LabelPositionHolder.from(stack), manager);
            if (manager != null) {
                manager.logger.info(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_SUCCEEDED_WITH_WARNINGS.get(successProgram.name(), warnings.size())));
                manager.logger.warn(warnings::forEach);
            }
            DiskItem.setProgramName(stack, successProgram.name());
            DiskItem.setWarnings(stack, warnings);
            DiskItem.setErrors(stack, Collections.emptyList());
            rtn.set(successProgram);
        }, errors -> {
            List<TranslatableContents> warnings = Collections.emptyList();
            if (manager != null) {
                manager.logger.error(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_FAILED_WITH_ERRORS.get(errors.size())));
                manager.logger.error(errors::forEach);
            }
            DiskItem.setWarnings(stack, warnings);
            DiskItem.setErrors(stack, errors);
        });
        return rtn.get();
    }

    public static List<Component> getErrors(ItemStack stack) {
        return (List)stack.getOrDefault(SFMDataComponents.PROGRAM_ERRORS, Collections.emptyList());
    }

    public static void setErrors(ItemStack stack, List<TranslatableContents> errors) {
        stack.set(SFMDataComponents.PROGRAM_ERRORS, errors.stream().map(MutableComponent::create).collect(Collectors.toList()));
    }

    public static List<Component> getWarnings(ItemStack stack) {
        return (List)stack.getOrDefault(SFMDataComponents.PROGRAM_WARNINGS, Collections.emptyList());
    }

    public static void setWarnings(ItemStack stack, List<TranslatableContents> warnings) {
        stack.set(SFMDataComponents.PROGRAM_WARNINGS, warnings.stream().map(MutableComponent::create).collect(Collectors.toList()));
    }

    public static void setProgramName(ItemStack stack, String name) {
        if (!name.isEmpty()) {
            stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)name));
        }
    }

    public static String getProgramName(ItemStack stack) {
        return ((Component)stack.getOrDefault(DataComponents.ITEM_NAME, (Object)Component.empty())).getString();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide) {
            SFMScreenChangeHelpers.showProgramEditScreen(new SFMTextEditScreenDiskOpenContext(DiskItem.getProgram(stack), LabelPositionHolder.from(stack), newProgramString -> SFMPackets.sendToServer(new ServerboundDiskItemSetProgramPacket((String)newProgramString, pUsedHand))));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide());
    }

    public Component getName(ItemStack stack) {
        if (SFMEnvironmentUtils.isClient() && SFMKeyMappings.isKeyDown(SFMKeyMappings.MORE_INFO_TOOLTIP_KEY)) {
            return super.getName(stack);
        }
        String name = DiskItem.getProgramName(stack);
        if (name.isEmpty()) {
            return super.getName(stack);
        }
        return Component.literal((String)name).withStyle(ChatFormatting.AQUA);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag detail) {
        String program = DiskItem.getProgram(stack);
        if (SFMItemUtils.isClientAndMoreInfoKeyPressed() && !program.isEmpty()) {
            lines.add((Component)SFMItemUtils.getRainbow(this.getName(stack).getString().length()));
            lines.addAll(ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(program, false));
        } else {
            lines.addAll(LabelPositionHolder.from(stack).asHoverText());
            DiskItem.getErrors(stack).stream().map(Component::copy).map(line -> line.withStyle(ChatFormatting.RED)).forEach(lines::add);
            DiskItem.getWarnings(stack).stream().map(Component::copy).map(line -> line.withStyle(ChatFormatting.YELLOW)).forEach(lines::add);
            if (!program.isEmpty()) {
                SFMItemUtils.appendMoreInfoKeyReminderTextIfOnClient(lines);
            }
        }
        if (!program.isEmpty()) {
            lines.add((Component)LocalizationKeys.DISK_EDIT_IN_HAND_TOOLTIP.getComponent().withStyle(ChatFormatting.GRAY));
        }
    }
}

