/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.Trigger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class SimulateExploreAllPathsProgramBehaviour
implements ProgramBehaviour {
    protected List<ExecutionPath> seenPaths = new ArrayList<ExecutionPath>();
    protected ExecutionPath currentPath = new ExecutionPath();
    protected AtomicReference<BigInteger> triggerPathCount = new AtomicReference<BigInteger>(BigInteger.ZERO);

    public SimulateExploreAllPathsProgramBehaviour() {
    }

    public SimulateExploreAllPathsProgramBehaviour(List<ExecutionPath> seenPaths, ExecutionPath currentPath, AtomicReference<BigInteger> triggerPathCount) {
        this.seenPaths = seenPaths;
        this.currentPath = currentPath.fork();
        this.triggerPathCount = triggerPathCount;
    }

    public void terminatePathAndBeginAnew() {
        this.seenPaths.add(this.currentPath);
        this.currentPath = new ExecutionPath();
        this.triggerPathCount.set(this.triggerPathCount.get().add(BigInteger.ONE));
    }

    public BigInteger getTriggerPathCount() {
        return this.triggerPathCount.get();
    }

    public void prepareNextTrigger() {
        this.triggerPathCount.set(BigInteger.ZERO);
    }

    public void pushPathElement(ExecutionPathElement statement) {
        this.currentPath.history.add(statement);
    }

    @Nullable
    public ExecutionPathElement getLatestPathElement() {
        if (this.currentPath.history.isEmpty()) {
            return null;
        }
        return this.currentPath.history.get(this.currentPath.history.size() - 1);
    }

    @Nullable
    public ExecutionPathElement getPathElementForNode(ASTNode node) {
        ListIterator<ExecutionPathElement> iterator = this.currentPath.history.listIterator(this.currentPath.history.size());
        while (iterator.hasPrevious()) {
            ExecutionPathElement element = iterator.previous();
            if (element instanceof Branch) {
                Branch branch = (Branch)element;
                if (branch.ifStatement == node) {
                    return element;
                }
            }
            if (!(element instanceof IO)) continue;
            IO io = (IO)element;
            if (io.statement != node) continue;
            return element;
        }
        return null;
    }

    public void onOutputStatementExecution(ProgramContext context, OutputStatement outputStatement) {
        this.pushPathElement(new IO(outputStatement));
    }

    public void onInputStatementExecution(ProgramContext context, InputStatement inputStatement) {
        this.pushPathElement(new IO(inputStatement));
    }

    public void onInputStatementForgetTransform(ProgramContext context, InputStatement old, InputStatement next) {
    }

    public void onInputStatementDropped(ProgramContext context, InputStatement inputStatement) {
    }

    public void onTriggerDropped(ProgramContext context, Trigger trigger) {
        context.getInputs().forEach(inputStatement -> this.onInputStatementDropped(context, (InputStatement)inputStatement));
    }

    @Override
    public ProgramBehaviour fork() {
        return new SimulateExploreAllPathsProgramBehaviour(this.seenPaths, this.currentPath, this.triggerPathCount);
    }

    public ExecutionPath getCurrentPath() {
        return this.currentPath;
    }

    public List<ExecutionPath> getSeenPaths() {
        return this.seenPaths;
    }

    public int[] getSeenIOStatementCountForEachPath() {
        return this.seenPaths.stream().mapToInt(path -> (int)path.history.stream().filter(IO.class::isInstance).count()).toArray();
    }

    public void onProgramFinished(ProgramContext context, Program program) {
    }

    public record ExecutionPath(List<ExecutionPathElement> history) {
        public ExecutionPath() {
            this(new ArrayList<ExecutionPathElement>());
        }

        public ExecutionPath fork() {
            return new ExecutionPath(new ArrayList<ExecutionPathElement>(this.history));
        }

        public Stream<ExecutionPathElement> stream() {
            return this.history.stream();
        }

        public Stream<Branch> streamBranches() {
            return this.history.stream().filter(Branch.class::isInstance).map(Branch.class::cast);
        }
    }

    public static interface ExecutionPathElement {
    }

    public record Branch(IfStatement ifStatement, boolean wasTrue) implements ExecutionPathElement
    {
    }

    public record IO(IOStatement statement, IOKind kind, ResourceType<?, ?, ?>[] usedResourceTypes, Set<Label> usedLabels) implements ExecutionPathElement
    {
        public IO(IOStatement statement) {
            this(statement, statement instanceof InputStatement ? IOKind.INPUT : (statement instanceof OutputStatement ? IOKind.OUTPUT : null), statement.resourceLimits().getReferencedResourceTypes(), new HashSet<Label>(statement.labelAccess().labels()));
            if (this.kind == null) {
                throw new IllegalArgumentException("Unknown IO statement type: " + String.valueOf(statement));
            }
        }
    }

    public static enum IOKind {
        INPUT,
        OUTPUT;

    }
}

