/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen;

import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ModTileContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SlotsGroup;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractBaseScreen<T extends AbstractModBlockEntity, C extends ModTileContainer<T>>
extends ModTileContainerScreen<T, C> {
    public static final int DEFAULT_GUI_WIDTH = 224;
    public static final int DEFAULT_GUI_HEIGHT = 166;
    public static final Style STYLE_TOOLTIP_TITLE = Style.EMPTY.withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true));
    public static final Style STYLE_TOOLTIP_VALUE = Style.EMPTY.withColor(ChatFormatting.DARK_AQUA).withBold(Boolean.valueOf(true));
    public static final Style STYLE_TOOLTIP_INFO = Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE).withItalic(Boolean.valueOf(true));
    private static final int TITLE_PANEL_HEIGHT = 21;
    private final ISpriteTextureMap _mainTextMap;
    private final ISprite _invMainSprite;
    private final ISprite _invHotBarSprite;
    private final ISprite _invSingleSprite;
    private final IControlContainer _contentPanel;
    private IControl _helpButton;
    private IControl _recipesButton;

    protected AbstractBaseScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, Supplier<@NotNull SpriteTextureMap> mainTextureSupplier) {
        this(container, inventory, inventoryUsage, title, 224, 166, mainTextureSupplier.get());
    }

    protected AbstractBaseScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, Supplier<@NotNull SpriteTextureMap> mainTextureSupplier) {
        this(container, inventory, inventoryUsage, title, guiWidth, guiHeight, mainTextureSupplier.get());
    }

    protected AbstractBaseScreen(C container, Inventory inventory, PlayerInventoryUsage inventoryUsage, Component title, int guiWidth, int guiHeight, SpriteTextureMap mainTexture) {
        super(container, inventory, title, guiWidth, guiHeight);
        this._mainTextMap = mainTexture;
        switch (inventoryUsage) {
            default: {
                this._invHotBarSprite = this._invSingleSprite = Sprite.EMPTY;
                this._invMainSprite = this._invSingleSprite;
                break;
            }
            case HotBar: {
                this._invHotBarSprite = this.createInventoryHotBarSprite();
                this._invMainSprite = Sprite.EMPTY;
                this._invSingleSprite = this.createInventorySingleSprite();
                break;
            }
            case MainInventory: {
                this._invHotBarSprite = Sprite.EMPTY;
                this._invMainSprite = this.createInventoryMainSprite();
                this._invSingleSprite = this.createInventorySingleSprite();
                break;
            }
            case Both: {
                this._invHotBarSprite = this.createInventoryHotBarSprite();
                this._invMainSprite = this.createInventoryMainSprite();
                this._invSingleSprite = this.createInventorySingleSprite();
            }
        }
        this._contentPanel = new Panel(this, "content");
        this._contentPanel.setLayoutEngine(new FixedLayoutEngine());
        this.setContentBounds(0, 0);
        this._recipesButton = null;
        this._helpButton = null;
    }

    protected void addControl(IControl control) {
        this._contentPanel.addControl(control);
    }

    protected void setContentPanelBackground(ISprite sprite) {
        this._contentPanel.setBackground(sprite);
    }

    protected void setContentPanelBackground(Colour colour) {
        this._contentPanel.setBackground(colour);
    }

    protected void setContentLayoutEngine(ILayoutEngine engine) {
        this._contentPanel.setLayoutEngine(engine);
    }

    protected void setContentBounds(int horizontalMargin, int verticalMargin) {
        this.setContentBounds(horizontalMargin, verticalMargin, this.getGuiWidth(), this.getGuiHeight());
    }

    protected void setContentBounds(int horizontalMargin, int verticalMargin, int width, int height) {
        width = Math.min(width - 2 * horizontalMargin, this.getGuiWidth());
        height = Math.min(height - 2 * verticalMargin - 21, this.getGuiHeight());
        this._contentPanel.setDesiredDimension(width, height);
        this._contentPanel.setLayoutEngineHint(FixedLayoutEngine.hint(horizontalMargin, 21 + verticalMargin, width, height));
    }

    protected int getContentWidth() {
        return this._contentPanel.getDesiredDimension(DesiredDimension.Width);
    }

    protected int getContentHeight() {
        return this._contentPanel.getDesiredDimension(DesiredDimension.Height);
    }

    protected void addPatchouliHelpButton(ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        this._helpButton = this.createPatchouliHelpButton(bookId, entryId, pageNum);
    }

    protected void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, Supplier<@NotNull ISprite> standardSprite) {
        this.setButtonSpritesAndOverlayForState(button, standardState, standardSprite.get());
    }

    protected void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, ISprite standardSprite) {
        button.setIconForState(standardSprite, standardState);
        ISprite withOverlay = standardSprite.copyWith(BaseIcons.Button16x16HightlightOverlay.get());
        button.setIconForState(withOverlay, standardState.getHighlighted());
        withOverlay = standardSprite.copyWith(BaseIcons.Button16x16DisabledOverlay.get());
        button.setIconForState(withOverlay, standardState.getDisabled());
    }

    protected void addRecipesButton(Runnable onClick, String tooltipTranslationKey) {
        this._recipesButton = this.createRecipesButton(onClick, tooltipTranslationKey);
    }

    @Nullable
    protected IControl getTitleBarWidget() {
        return null;
    }

    protected SlotsGroup createSingleSlotGroupControl(String controlName, String inventorySlotsGroupName) {
        return this.createMonoSlotGroupControl(controlName, inventorySlotsGroupName, this._invSingleSprite, 1);
    }

    protected SlotsGroup createPlayerHotBarSlotsGroupControl() {
        return this.createPlayerHotBarSlotsGroupControl(this._invHotBarSprite, 1);
    }

    protected SlotsGroup createPlayerInventorySlotsGroupControl() {
        return this.createPlayerInventorySlotsGroupControl(this._invMainSprite, 1);
    }

    @Override
    protected void onScreenCreate() {
        super.onScreenCreate();
        int guiWidth = this.getGuiWidth();
        int guiHeight = this.getGuiHeight();
        Panel mainPanel = new Panel(this, "mainPanel");
        Panel titlePanel = new Panel(this, "titlePanel");
        mainPanel.setDesiredDimension(DesiredDimension.Height, guiHeight);
        mainPanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        mainPanel.setLayoutEngineHint(FixedLayoutEngine.hint(0, 0, guiWidth, guiHeight));
        mainPanel.setBackground(this._mainTextMap.sprite().ofSize(guiWidth, guiHeight).build());
        mainPanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        titlePanel.setDesiredDimension(DesiredDimension.Height, 21);
        titlePanel.setDesiredDimension(DesiredDimension.Width, guiWidth);
        titlePanel.setLayoutEngineHint(FixedLayoutEngine.hint(0, 0, guiWidth, 21));
        titlePanel.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine().setZeroMargins());
        IControl titleWidget = this.getTitleBarWidget();
        int titlePosX = 7;
        int titleWidth = guiWidth - 14;
        if (null != titleWidget) {
            titleWidget.setLayoutEngineHint(FixedLayoutEngine.hint(7, 7, 10, 10));
            titlePanel.addControl(titleWidget);
            titlePosX += 10;
            titleWidth -= 10;
        }
        int helpButtonsX = guiWidth - 18;
        if (null != this._helpButton) {
            this._helpButton.setLayoutEngineHint(FixedLayoutEngine.hint(helpButtonsX, 6, 12, 12));
            titlePanel.addControl(this._helpButton);
            titleWidth -= 12;
            helpButtonsX -= 13;
        }
        if (null != this._recipesButton) {
            this._recipesButton.setLayoutEngineHint(FixedLayoutEngine.hint(helpButtonsX, 6, 12, 12));
            titlePanel.addControl(this._recipesButton);
            titleWidth -= 12;
            helpButtonsX -= 13;
        }
        Label title = new Label((ModContainerScreen<? extends ModContainer>)this, "title", this.getTitle());
        title.setPadding(2);
        title.setColor(this.getTheme().GUI_TITLE);
        title.setAutoSize(false);
        title.setLayoutEngineHint(FixedLayoutEngine.hint(titlePosX, 7, titleWidth, 12));
        titlePanel.addControl((IControl)title);
        this._contentPanel.removeControls();
        mainPanel.addControl(titlePanel, this._contentPanel);
        this.createWindow(mainPanel, true);
    }

    private ISprite createInventoryHotBarSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(162, 18).build();
    }

    private ISprite createInventoryMainSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(162, 54).build();
    }

    private ISprite createInventorySingleSprite() {
        return this._mainTextMap.sprite().from(0, 202).ofSize(18, 18).build();
    }
}

