/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.power.charging;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.AbstractPowerPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.charging.IChargingPortHandler;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.handler.TileEntityItemStackHandler;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class AbstractChargingPortHandler<Controller extends AbstractCuboidMultiblockController<Controller>, Port extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerPortHandler<Controller, Port>
implements IChargingPortHandler,
ISyncableEntity {
    private final ItemStackHandler _input;
    private final ItemStackHandler _output;
    private WideAmount _chargingRate;

    protected AbstractChargingPortHandler(EnergySystem energySystem, Port port, int inputSlotsCount, int outputSlotsCount) {
        super(energySystem, port, IoMode.Active);
        this._input = new TileEntityItemStackHandler((BlockEntity)port, inputSlotsCount);
        this._output = new TileEntityItemStackHandler((BlockEntity)port, outputSlotsCount);
        this._chargingRate = WideAmount.ZERO;
    }

    protected WideAmount getChargingRate() {
        if (this._chargingRate.isZero()) {
            this._chargingRate = ((IPowerPort)this.getIoEntity()).getMaxTransferRate();
        }
        return this._chargingRate;
    }

    protected void eject(int inputSlotIndex) {
        ItemStack input = this._input.getStackInSlot(inputSlotIndex);
        if (!input.isEmpty()) {
            for (int idx = 0; idx < this.getOutputSlotsCount(); ++idx) {
                if (!this._output.getStackInSlot(idx).isEmpty()) continue;
                this._output.setStackInSlot(idx, input);
                this._input.setStackInSlot(inputSlotIndex, ItemStack.EMPTY);
                return;
            }
        }
    }

    protected int getInputSlotsCount() {
        return this._input.getSlots();
    }

    protected int getOutputSlotsCount() {
        return this._output.getSlots();
    }

    @Override
    public IItemHandlerModifiable getItemStackHandler(IoDirection direction) {
        return direction.isInput() ? this._input : this._output;
    }

    @Override
    public void eject() {
        for (int idx = 0; idx < this.getInputSlotsCount(); ++idx) {
            this.eject(idx);
        }
    }

    @Override
    public boolean isConnected() {
        for (int idx = 0; idx < this.getInputSlotsCount(); ++idx) {
            if (this._input.getStackInSlot(idx).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onPortChanged() {
    }

    @Override
    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvFrom(data, registries, "in", this._input);
            AbstractChargingPortHandler.syncInvFrom(data, registries, "out", this._output);
        }
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvTo(data, registries, "in", this._input);
            AbstractChargingPortHandler.syncInvTo(data, registries, "out", this._output);
        }
        return data;
    }

    private static void syncInvTo(CompoundTag data, HolderLookup.Provider registries, String name, ItemStackHandler inv) {
        data.put(name, (Tag)inv.serializeNBT(registries));
    }

    private static void syncInvFrom(CompoundTag data, HolderLookup.Provider registries, String name, ItemStackHandler inv) {
        if (data.contains(name)) {
            inv.deserializeNBT(registries, data.getCompound(name));
        }
    }
}

