/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.compat.patchouli;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.compat.patchouli.IPatchouliService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public final class PatchouliService
implements IPatchouliService {
    private final PatchouliAPI.IPatchouliAPI _patchouli = PatchouliAPI.get();
    private final Map<IMultiblock, Function<BlockState, BlockState>> _renderBlockStateMappers = new HashMap<IMultiblock, Function<BlockState, BlockState>>();
    private final Map<IMultiblock, Function<BlockState, ModelData>> _modelDataMappers = new HashMap<IMultiblock, Function<BlockState, ModelData>>();

    public BlockState getRenderBlockStateFor(IMultiblock multiblock, BlockState blockState) {
        return this._renderBlockStateMappers.getOrDefault(multiblock, bs -> bs).apply(blockState);
    }

    public ModelData getModelDataFor(IMultiblock multiblock, BlockState blockState) {
        return this._modelDataMappers.getOrDefault(multiblock, b -> ModelData.EMPTY).apply(blockState);
    }

    @Override
    public void registerMultiblock(ResourceLocation id, Function<BlockState, BlockState> renderBlockStateMappers, Function<BlockState, ModelData> modelDataMapper, String[][] pattern, Object ... targets) {
        IMultiblock multiblock = this._patchouli.makeMultiblock(pattern, targets);
        this._patchouli.registerMultiblock(id, multiblock);
        this._renderBlockStateMappers.put(multiblock, renderBlockStateMappers);
        this._modelDataMappers.put(multiblock, modelDataMapper);
    }

    @Override
    public void openBookEntry(ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        Preconditions.checkNotNull((Object)bookId, (Object)"Book ID must not be null");
        Preconditions.checkNotNull((Object)entryId, (Object)"Entry ID must not be null");
        Preconditions.checkArgument((pageNum >= 0 ? 1 : 0) != 0, (Object)"Page number must be positive");
        try {
            this._patchouli.openBookEntry(bookId, entryId, pageNum);
        }
        catch (Exception ex) {
            Log.LOGGER.error(Log.CORE, "Failed to open a Patchouli book.", (Throwable)ex);
        }
    }

    @Override
    public void consumeBookStack(ResourceLocation bookId, Consumer<ItemStack> consumer) {
        ItemStack stack = this._patchouli.getBookStack(bookId);
        if (!stack.isEmpty()) {
            consumer.accept(stack);
        }
    }
}

