/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.layout.AbstractLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ControlLayoutPosition;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;

public class HorizontalLayoutEngine
extends AbstractLayoutEngine<HorizontalLayoutEngine> {
    @Override
    public void layout(IControlContainer controlsContainer) {
        Rectangle parentBounds = controlsContainer.getBounds();
        int defaultWidth = this.computeDefaultValueForUndefinedDimension(controlsContainer, DesiredDimension.Width, parentBounds.Width);
        int spacing = this.getControlsSpacing();
        int verticalMargin = this.getVerticalMargin();
        int maxHeight = parentBounds.Height - 2 * verticalMargin;
        ObjectArrayList positions = new ObjectArrayList(controlsContainer.getControlsCount());
        int availableSpace = parentBounds.Width - 2 * this.getHorizontalMargin() - (controlsContainer.getControlsCount() - 1) * spacing;
        for (IControl control : controlsContainer) {
            int controlWidth = Math.min(availableSpace, this.getControlDesiredDimension(control, DesiredDimension.Width, defaultWidth));
            positions.add(this.computeLayoutPosition(control, 0, verticalMargin, controlWidth, maxHeight));
            availableSpace -= controlWidth;
        }
        int left = switch (this.getHorizontalAlignment()) {
            default -> throw new MatchException(null, null);
            case HorizontalAlignment.Left -> 0;
            case HorizontalAlignment.Right -> availableSpace;
            case HorizontalAlignment.Center -> availableSpace / 2;
        };
        for (ControlLayoutPosition position : positions) {
            position.layoutAtX(left);
            left += position.with() + spacing;
        }
    }
}

