/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import com.google.common.base.Preconditions;

public class IntegerBitField {
    private int _bits;

    public IntegerBitField() {
        this(0);
    }

    public IntegerBitField(int initialValue) {
        this._bits = initialValue;
    }

    public int getValue() {
        return this._bits;
    }

    public boolean checkBit(int bitPosition) {
        return 1 == this.getBit(bitPosition);
    }

    public int getBit(int bitPosition) {
        Preconditions.checkArgument((bitPosition >= 0 && bitPosition < 32 ? 1 : 0) != 0);
        int mask = bitPosition > 0 ? 1 << bitPosition : 1;
        return (this._bits & mask) >> bitPosition;
    }

    public int setBit(int bitPosition) {
        Preconditions.checkArgument((bitPosition >= 0 && bitPosition < 32 ? 1 : 0) != 0);
        int mask = bitPosition > 0 ? 1 << bitPosition : 1;
        return this._bits |= mask;
    }

    public int clearBit(int bitPosition) {
        Preconditions.checkArgument((bitPosition >= 0 && bitPosition < 32 ? 1 : 0) != 0);
        int mask = bitPosition > 0 ? ~(1 << bitPosition) : 0;
        return this._bits &= mask;
    }

    public int modifyBit(int bitPosition, boolean newValue) {
        return newValue ? this.setBit(bitPosition) : this.clearBit(bitPosition);
    }

    public int modifyBits(int startBitPosition, int rangeLength, int newValue) {
        Preconditions.checkArgument((rangeLength > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((startBitPosition >= 0 && startBitPosition + rangeLength < 32 ? 1 : 0) != 0);
        int mask = rangeLength < 32 ? -1 >>> 32 - rangeLength : -1;
        newValue &= mask;
        if (startBitPosition > 0) {
            newValue <<= startBitPosition;
        }
        return this._bits |= newValue;
    }
}

