/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class CuboidBoundingBox
implements Iterable<BlockPos> {
    public static final CuboidBoundingBox EMPTY = new CuboidBoundingBox(){

        @Override
        public AABB getAABB() {
            return CodeHelper.EMPTY_BOUNDING_BOX;
        }

        @Override
        public CuboidBoundingBox add(BlockPos position) {
            return new CuboidBoundingBox((Vec3i)position, (Vec3i)position);
        }

        @Override
        public CuboidBoundingBox remove(BlockPos position) {
            return EMPTY;
        }

        @Override
        public CuboidBoundingBox combine(CuboidBoundingBox other) {
            return new CuboidBoundingBox((Vec3i)other._min, (Vec3i)other._max);
        }

        @Override
        public boolean equals(Object other) {
            return other == EMPTY;
        }
    };
    private final BlockPos.MutableBlockPos _min;
    private final BlockPos.MutableBlockPos _max;

    public CuboidBoundingBox() {
        this((Vec3i)CodeHelper.MAX_BLOCKPOS, (Vec3i)CodeHelper.MIN_BLOCKPOS);
    }

    public CuboidBoundingBox(Vec3i min, Vec3i max) {
        this._min = new BlockPos.MutableBlockPos(min.getX(), min.getY(), min.getZ());
        this._max = new BlockPos.MutableBlockPos(max.getX(), max.getY(), max.getZ());
    }

    public CuboidBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this._min = new BlockPos.MutableBlockPos(minX, minY, minZ);
        this._max = new BlockPos.MutableBlockPos(maxX, maxY, maxZ);
    }

    public BlockPos getMin() {
        return this._min.immutable();
    }

    public BlockPos getMax() {
        return this._max.immutable();
    }

    public int getMinX() {
        return this._min.getX();
    }

    public int getMinY() {
        return this._min.getY();
    }

    public int getMinZ() {
        return this._min.getZ();
    }

    public int getMaxX() {
        return this._max.getX();
    }

    public int getMaxY() {
        return this._max.getY();
    }

    public int getMaxZ() {
        return this._max.getZ();
    }

    public AABB getAABB() {
        return new AABB((double)this._min.getX(), (double)this._min.getY(), (double)this._min.getZ(), (double)this._max.getX(), (double)this._min.getY(), (double)this._min.getZ());
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public CuboidBoundingBox add(BlockPos position) {
        CuboidBoundingBox.adjustPosition(this._min, position, Math::min);
        CuboidBoundingBox.adjustPosition(this._max, position, Math::max);
        return this;
    }

    public CuboidBoundingBox remove(BlockPos position) {
        return EMPTY;
    }

    public CuboidBoundingBox combine(CuboidBoundingBox other) {
        CuboidBoundingBox.adjustPosition(this._min, (BlockPos)other._min, Math::min);
        CuboidBoundingBox.adjustPosition(this._max, (BlockPos)other._max, Math::max);
        return this;
    }

    public boolean contains(Vec3i vec) {
        return this.contains(vec.getX(), vec.getY(), vec.getZ());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this._min.getX() && x <= this._max.getX() && y >= this._min.getY() && y <= this._max.getY() && z >= this._min.getZ() && z <= this._max.getZ();
    }

    public int getLengthX() {
        return this._max.getX() - this._min.getX() + 1;
    }

    public int getLengthY() {
        return this._max.getY() - this._min.getY() + 1;
    }

    public int getLengthZ() {
        return this._max.getZ() - this._min.getZ() + 1;
    }

    public int getLength(Direction.Axis axis) {
        switch (axis) {
            default: {
                return this.getLengthX();
            }
            case Y: {
                return this.getLengthY();
            }
            case Z: 
        }
        return this.getLengthZ();
    }

    public int getVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume((BlockPos)this._min, (BlockPos)this._max);
    }

    public int getInternalVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume(this._min.getX() + 1, this._min.getY() + 1, this._min.getZ() + 1, this._max.getX() - 1, this._max.getY() - 1, this._max.getZ() - 1);
    }

    public BlockPos getCenter() {
        return this._min.offset(this.getLengthX() / 2, this.getLengthY() / 2, this.getLengthZ() / 2);
    }

    public int commonVertices(Vec3i position) {
        return CodeHelper.commonVertices(position, (Vec3i)this._min) + CodeHelper.commonVertices(position, (Vec3i)this._max);
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper) {
        return mapper.apply(this.getMin(), this.getMax());
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper, Function<@NotNull BlockPos, @NotNull BlockPos> minRemapper, Function<@NotNull BlockPos, @NotNull BlockPos> maxRemapper) {
        return mapper.apply(minRemapper.apply(this.getMin()), maxRemapper.apply(this.getMax()));
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer) {
        consumer.accept(this.getMin(), this.getMax());
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer, Function<@NotNull BlockPos, @NotNull BlockPos> minRemapper, Function<@NotNull BlockPos, @NotNull BlockPos> maxRemapper) {
        consumer.accept(minRemapper.apply(this.getMin()), maxRemapper.apply(this.getMax()));
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new AbstractIterator<BlockPos>(){
            final BlockPos.MutableBlockPos _cursor = new BlockPos.MutableBlockPos();
            final int _minX;
            final int _minY;
            final int _minZ;
            final int _maxX;
            final int _maxY;
            final int _maxZ;
            int _currentX;
            int _currentY;
            int _currentZ;
            {
                this._minX = CuboidBoundingBox.this._min.getX();
                this._minY = CuboidBoundingBox.this._min.getY();
                this._minZ = CuboidBoundingBox.this._min.getZ();
                this._maxX = CuboidBoundingBox.this._max.getX();
                this._maxY = CuboidBoundingBox.this._max.getY();
                this._maxZ = CuboidBoundingBox.this._max.getZ();
                this._currentX = this._minX - 1;
                this._currentY = this._minY;
                this._currentZ = this._minZ;
            }

            protected BlockPos computeNext() {
                ++this._currentX;
                if (this._currentX > this._maxX) {
                    this._currentX = this._minX;
                    ++this._currentZ;
                    if (this._currentZ > this._maxZ) {
                        this._currentZ = this._minZ;
                        ++this._currentY;
                        if (this._currentY > this._maxY) {
                            return (BlockPos)this.endOfData();
                        }
                    }
                }
                return this._cursor.set(this._currentX, this._currentY, this._currentZ);
            }
        };
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CuboidBoundingBox)) {
            return false;
        }
        CuboidBoundingBox otherBB = (CuboidBoundingBox)other;
        return 0 == this._min.compareTo((Vec3i)otherBB._min) && 0 == this._max.compareTo((Vec3i)otherBB._max);
    }

    public int hashCode() {
        return Objects.hash(this._min, this._max);
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : String.format("%s -> %s", CodeHelper.toString((Vec3i)this._min), CodeHelper.toString((Vec3i)this._max));
    }

    private static boolean adjustPosition(BlockPos.MutableBlockPos currentPosition, BlockPos newPosition, IntComparator minMax) {
        int curX = currentPosition.getX();
        int curY = currentPosition.getY();
        int curZ = currentPosition.getZ();
        int newX = minMax.compare(currentPosition.getX(), newPosition.getX());
        int newY = minMax.compare(currentPosition.getY(), newPosition.getY());
        int newZ = minMax.compare(currentPosition.getZ(), newPosition.getZ());
        if (newX != curX || newY != curY || newZ != curZ) {
            currentPosition.set(newX, newY, newZ);
            return true;
        }
        return false;
    }
}

