/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.gfx;

import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import java.util.Objects;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class Colour {
    public static final ModCodecs<Colour, ByteBuf> CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("r").forGetter(c -> c.R), (App)Codec.BYTE.fieldOf("g").forGetter(c -> c.G), (App)Codec.BYTE.fieldOf("b").forGetter(c -> c.B), (App)Codec.BYTE.fieldOf("a").forGetter(c -> c.A)).apply((Applicative)instance, Colour::new)), StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, c -> c.R, (StreamCodec)ByteBufCodecs.BYTE, c -> c.G, (StreamCodec)ByteBufCodecs.BYTE, c -> c.B, (StreamCodec)ByteBufCodecs.BYTE, c -> c.A, Colour::new));
    public static final Colour WHITE = new Colour(255, 255, 255, 255);
    public static final Colour BLACK = new Colour(0, 0, 0, 255);
    public final byte R;
    public final byte G;
    public final byte B;
    public final byte A;

    public Colour(int r, int g, int b, int a) {
        this.R = (byte)r;
        this.G = (byte)g;
        this.B = (byte)b;
        this.A = (byte)a;
    }

    public Colour(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Colour(double r, double g, double b, double a) {
        this((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0), (int)(a * 255.0));
    }

    public Colour(double r, double g, double b) {
        this(r, g, b, 255.0);
    }

    public Colour(Colour other) {
        this(other.R, other.G, other.B, other.A);
    }

    public Colour(DyeColor color, int a) {
        this(Colour.rgbRed(color.getTextColor()), Colour.rgbGreen(color.getTextColor()), Colour.rgbBlue(color.getTextColor()), a);
    }

    public Colour(DyeColor color) {
        this(color, 255);
    }

    public static Colour from(Colour colour) {
        return new Colour(colour);
    }

    public static Colour from(DyeColor colour) {
        return new Colour(colour, 255);
    }

    public static Colour from(DyeColor colour, int alpha) {
        return new Colour(colour, alpha);
    }

    public static Colour fromRGB(int packedRGB) {
        return new Colour(packedRGB >> 16 & 0xFF, packedRGB >> 8 & 0xFF, packedRGB & 0xFF, 255);
    }

    public static Colour fromARGB(int packedARGB) {
        return new Colour(packedARGB >> 16 & 0xFF, packedARGB >> 8 & 0xFF, packedARGB & 0xFF, packedARGB >> 24 & 0xFF);
    }

    public static Colour fromRGBA(int packedRGBA) {
        return new Colour(packedRGBA >> 24 & 0xFF, packedRGBA >> 16 & 0xFF, packedRGBA >> 8 & 0xFF, packedRGBA & 0xFF);
    }

    public static Colour fromHexRGB(String text) {
        return Colour.fromHexString(text, Colour::fromRGB);
    }

    public static Colour fromHexARGB(String text) {
        return Colour.fromHexString(text, Colour::fromARGB);
    }

    public static Colour fromHexRGBA(String text) {
        return Colour.fromHexString(text, Colour::fromRGBA);
    }

    public int toRGB() {
        return Colour.RGB(this.R, this.G, this.B);
    }

    public int toARGB() {
        return Colour.ARGB(this.R, this.G, this.B, this.A);
    }

    public int toRGBA() {
        return Colour.RGBA(this.R, this.G, this.B, this.A);
    }

    public String toHexRGB() {
        return Colour.toHexString(this.toRGB());
    }

    public String toHexARGB() {
        return Colour.toHexString(this.toARGB());
    }

    public String toHexRGBA() {
        return Colour.toHexString(this.toRGBA());
    }

    public static float toFloat(byte component) {
        return (float)(component & 0xFF) / 255.0f;
    }

    public static int RGB(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int RGB(byte r, byte g, byte b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int RGB(double r, double g, double b) {
        return Colour.RGB((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public static int RGBA(int r, int g, int b, int a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static int RGBA(byte r, byte g, byte b, byte a) {
        return (r & 0xFF) << 24 | (g & 0xFF) << 16 | (b & 0xFF) << 8 | a & 0xFF;
    }

    public static int RGBA(double r, double g, double b, double a) {
        return Colour.RGBA((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0), (int)(a * 255.0));
    }

    public static int ARGB(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int ARGB(byte r, byte g, byte b, byte a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int rgbRed(int rgb) {
        return (rgb & 0xFF0000) >> 16;
    }

    public static int rgbGreen(int rgb) {
        return (rgb & 0xFF00) >> 8;
    }

    public static int rgbBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static int ARGB(double r, double g, double b, double a) {
        return Colour.ARGB((int)(a * 255.0), (int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public float glRed() {
        return Colour.toFloat(this.R);
    }

    public float glGreen() {
        return Colour.toFloat(this.G);
    }

    public float glBlue() {
        return Colour.toFloat(this.B);
    }

    public float glAlpha() {
        return Colour.toFloat(this.A);
    }

    public boolean equals(Object other) {
        if (other instanceof Colour) {
            Colour c = (Colour)other;
            return this.R == c.R && this.G == c.G && this.B == c.B && this.A == c.A;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.R, this.G, this.B, this.A);
    }

    public String toString() {
        return String.format("Colour R 0x%02x, G 0x%02x, B 0x%02x, A 0x%02x", this.R, this.G, this.B, this.A);
    }

    private Colour() {
        this.B = 0;
        this.G = 0;
        this.R = 0;
        this.A = (byte)-1;
    }

    private static Colour fromHexString(String text, IntFunction<@NotNull Colour> factory) {
        if (Strings.isNullOrEmpty((String)text)) {
            throw new IllegalArgumentException("Invalid colour string");
        }
        if (text.startsWith("#")) {
            text = text.substring(1);
        }
        long value = Long.parseLong(text, 16);
        return factory.apply((int)value);
    }

    private static String toHexString(int value) {
        return String.format("%08X", value);
    }
}

