/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.IModDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.loot.SubProviderBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.IIntrinsicTagDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.tag.ITagDataProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public interface IModDataGenerator {
    public CompletableFuture<HolderLookup.Provider> getRegistryLookup();

    public ResourceLocationBuilder getModRoot();

    public <P extends DataProvider> void addProvider(DataProvider.Factory<P> var1);

    default public <P extends IModDataProvider> void addProvider(final IModDataProvider.ModFactory<P> factory) {
        this.addProvider(output -> new DataProvider(){
            private final IModDataProvider _provider;
            {
                this._provider = factory.create(output, IModDataGenerator.this.getRegistryLookup(), IModDataGenerator.this.getModRoot());
            }

            public CompletableFuture<?> run(CachedOutput cache) {
                this._provider.provideData();
                return this._provider.lookup(lookup -> this._provider.processData(cache, (HolderLookup.Provider)lookup));
            }

            public String getName() {
                return this._provider.getSettings().name();
            }
        });
    }

    public <T> void addTagsProvider(ResourceKey<? extends Registry<T>> var1, ITagDataProvider<T> var2);

    public <T> void addTagsProvider(ResourceKey<? extends Registry<T>> var1, Function<@NotNull T, @NotNull ResourceKey<T>> var2, IIntrinsicTagDataProvider<T> var3);

    default public void addBlockTagsProvider(IIntrinsicTagDataProvider<Block> provider) {
        this.addTagsProvider(Registries.BLOCK, $ -> $.builtInRegistryHolder().key(), provider);
    }

    default public void addItemTagsProvider(IIntrinsicTagDataProvider<Item> provider) {
        this.addTagsProvider(Registries.ITEM, $ -> $.builtInRegistryHolder().key(), provider);
    }

    default public void addEntityTypeTagsProvider(IIntrinsicTagDataProvider<EntityType<?>> provider) {
        this.addTagsProvider(Registries.ENTITY_TYPE, $ -> $.builtInRegistryHolder().key(), provider);
    }

    default public void addFluidTagsProvider(IIntrinsicTagDataProvider<Fluid> provider) {
        this.addTagsProvider(Registries.FLUID, $ -> $.builtInRegistryHolder().key(), provider);
    }

    default public void addLootProvider(Set<ResourceKey<LootTable>> requiredTables, Consumer<@NotNull SubProviderBuilder> subProvidersBuilder) {
        Preconditions.checkNotNull(requiredTables, (Object)"Required tables must not be null");
        Preconditions.checkNotNull(subProvidersBuilder, (Object)"Sub providers builder must not be null");
        SubProviderBuilder builder = (SubProviderBuilder)Util.make((Object)new SubProviderBuilder(), subProvidersBuilder);
        this.addProvider(output -> new LootTableProvider(output, requiredTables, builder.getEntries(), this.getRegistryLookup()));
    }

    default public void addLootProvider(Consumer<@NotNull SubProviderBuilder> subProvidersBuilder) {
        this.addLootProvider(Set.of(), subProvidersBuilder);
    }
}

