/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.AbstractModRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.AbstractManyToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ManyToOneRecipeBuilder<Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractManyToOneRecipe<Ingredient, Result, RecipeIngredient, RecipeResult>>
extends AbstractModRecipeBuilder<Recipe, Result, RecipeResult, ManyToOneRecipeBuilder<Ingredient, Result, RecipeIngredient, RecipeResult, Recipe>> {
    private final Supplier<@NotNull Recipe> _recipeFactory;
    private final List<RecipeIngredient> _ingredients;

    public ManyToOneRecipeBuilder(RecipeResult result, BiFunction<List<RecipeIngredient>, RecipeResult, Recipe> recipeFactory) {
        super(result);
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0, (Object)"Result cannot be empty");
        Preconditions.checkNotNull(recipeFactory, (Object)"Recipe factory cannot be empty");
        this._ingredients = new ObjectArrayList(4);
        this._recipeFactory = () -> Objects.requireNonNull((AbstractManyToOneRecipe)recipeFactory.apply(this._ingredients, result));
    }

    @Override
    protected Recipe getRecipe() {
        return (Recipe)((AbstractManyToOneRecipe)this._recipeFactory.get());
    }

    public void addIngredient(RecipeIngredient ingredient) {
        Preconditions.checkArgument((!ingredient.isEmpty() ? 1 : 0) != 0, (Object)"An ingredient cannot be empty");
        this._ingredients.add(ingredient);
    }
}

