/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container;

import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ModTileContainer<T extends AbstractModBlockEntity>
extends ModContainer {
    private final T _tile;

    public ModTileContainer(boolean isClientSide, int ticksBetweenUpdates, ContainerFactory factory, MenuType<? extends ModTileContainer<T>> type, int windowId, Inventory playerInventory, T tile) {
        super(isClientSide, ticksBetweenUpdates, factory, type, windowId, playerInventory);
        this._tile = tile;
        if (tile instanceof IConditionallySyncableEntity) {
            this.syncFrom((IConditionallySyncableEntity)tile);
        }
    }

    public ModTileContainer(boolean isClientSide, int ticksBetweenUpdates, ContainerFactory factory, MenuType<? extends ModTileContainer<T>> type, int windowId, T tile, ServerPlayer player) {
        this(isClientSide, ticksBetweenUpdates, factory, type, windowId, player.getInventory(), tile);
        if (this._tile instanceof INetworkTileEntitySyncProvider) {
            ((INetworkTileEntitySyncProvider)this._tile).enlistForUpdates(player, true);
        }
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(boolean isClientSide, MenuType<? extends ModTileContainer<T>> type, int windowId, Inventory playerInventory, T tile) {
        return new ModTileContainer<T>(isClientSide, 200, ContainerFactory.EMPTY, type, windowId, playerInventory, tile){

            public void setItem(int slotID, int stateId, ItemStack stack) {
            }
        };
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(boolean isClientSide, MenuType<? extends ModTileContainer<T>> type, int windowId, T tile, ServerPlayer player) {
        return new ModTileContainer<T>(isClientSide, 200, ContainerFactory.EMPTY, type, windowId, tile, player){

            public void setItem(int slotID, int stateId, ItemStack stack) {
            }
        };
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(boolean isClientSide, MenuType<? extends ModTileContainer<T>> type, int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        return ModTileContainer.empty(isClientSide, type, windowId, playerInventory, AbstractModBlockEntity.getGuiClientBlockEntity(data));
    }

    public T getTileEntity() {
        return this._tile;
    }

    @Override
    public boolean stillValid(Player player) {
        return ModTileContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)Objects.requireNonNull(this._tile.getLevel()), (BlockPos)this._tile.getBlockPos()), (Player)player, (Block)((AbstractModBlockEntity)this._tile).getBlockType());
    }

    public void removed(Player player) {
        super.removed(player);
        if (this._tile instanceof INetworkTileEntitySyncProvider && player instanceof ServerPlayer) {
            ((INetworkTileEntitySyncProvider)this._tile).delistFromUpdates((ServerPlayer)player);
        }
    }
}

