/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;

public class Sampler<T>
implements Supplier<T> {
    private final Supplier<T> _getter;
    private final int _frequency;
    private int _time;
    private T _sample;

    public Sampler(int frequency, Supplier<T> getter) {
        Preconditions.checkNotNull(getter, (Object)"Getter must not be null.");
        Preconditions.checkArgument((frequency > 0 ? 1 : 0) != 0, (Object)"Frequency must be greater than zero.");
        this._getter = getter;
        this._frequency = this._time = frequency;
    }

    @Override
    public T get() {
        if (null == this._sample) {
            this._sample = this._getter.get();
            return this._sample;
        }
        if (0 == --this._time) {
            this._time = this._frequency;
            this._sample = this._getter.get();
        }
        return this._sample;
    }
}

