/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShortData
extends AbstractData<Short>
implements IContainerData {
    private short _lastValue;

    public static ShortData immutable(ModContainer container, short value) {
        return ShortData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static ShortData sampled(int frequency, ModContainer container, Supplier<@NotNull Short> getter, Consumer<@NotNull Short> clientSideSetter) {
        return ShortData.of(container, new Sampler<Short>(frequency, getter), clientSideSetter);
    }

    public static ShortData sampled(int frequency, ModContainer container, Supplier<@NotNull Short> getter) {
        return ShortData.of(container, new Sampler<Short>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static ShortData of(ModContainer container, Supplier<@NotNull Short> getter, Consumer<@NotNull Short> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        ShortData data = container.isClientSide() ? new ShortData(getter, clientSideSetter) : new ShortData(getter);
        container.addBindableData(data);
        return data;
    }

    public static ShortData of(ModContainer container, short[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return ShortData.of(container, () -> array[index], v -> {
            array[index] = v;
        });
    }

    public static ShortData of(ModContainer container, Supplier<@NotNull Short> getter) {
        return ShortData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        short current = (Short)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return new ShortEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return ShortEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof ShortEntry) {
            ShortEntry record = (ShortEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public Short defaultValue() {
        return (short)0;
    }

    private ShortData(Supplier<Short> getter, Consumer<Short> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private ShortData(Supplier<Short> getter) {
        super(getter);
        this._lastValue = 0;
    }

    private record ShortEntry(short value) implements ISyncedSetEntry
    {
        private static ShortEntry from(RegistryFriendlyByteBuf buffer) {
            return new ShortEntry(buffer.readShort());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeShort((int)this.value);
        }
    }
}

