/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.rectangular;

import it.zerono.mods.zerocore.lib.multiblock.rectangular.AbstractRectangularMultiblockController;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public enum PartPosition implements StringRepresentable
{
    Unknown,
    FrameCorner,
    FrameEastWest,
    FrameSouthNorth,
    FrameUpDown;


    public static <Controller extends AbstractRectangularMultiblockController<Controller>> PartPosition positionIn(Controller controller, BlockPos blockPosition) {
        return controller.mapBoundingBoxCoordinates((min, max) -> PartPosition.positionIn(blockPosition, min, max), (PartPosition)Unknown);
    }

    public boolean isFrame() {
        return this != Unknown;
    }

    public boolean isCorner() {
        return this == FrameCorner;
    }

    public static EnumProperty<PartPosition> createProperty(String name) {
        return EnumProperty.create((String)name, PartPosition.class);
    }

    public String getSerializedName() {
        return this.toString();
    }

    private static PartPosition positionIn(BlockPos blockPosition, BlockPos minimumCoord, BlockPos maximumCoord) {
        boolean downFacing = blockPosition.getY() == minimumCoord.getY();
        boolean upFacing = blockPosition.getY() == maximumCoord.getY();
        boolean northFacing = blockPosition.getZ() == minimumCoord.getZ();
        boolean southFacing = blockPosition.getZ() == maximumCoord.getZ();
        boolean westFacing = blockPosition.getX() == minimumCoord.getX();
        boolean eastFacing = blockPosition.getX() == maximumCoord.getX();
        int facesMatching = 0;
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        PartPosition position = 3 == facesMatching ? FrameCorner : (2 == facesMatching ? (!eastFacing && !westFacing ? FrameEastWest : (!southFacing && !northFacing ? FrameSouthNorth : FrameUpDown)) : Unknown);
        return position;
    }
}

