/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public abstract class AbstractManyToOneRecipe<Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>>
extends ModRecipe
implements Predicate<List<Ingredient>> {
    private final List<RecipeIngredient> _ingredients;
    private final RecipeResult _result;

    protected AbstractManyToOneRecipe(List<RecipeIngredient> ingredients, RecipeResult result) {
        Preconditions.checkArgument((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"Trying to create a recipe without ingredients");
        ObjectArrayList copy = ingredients.size() == 1 ? ObjectLists.singleton((Object)((IRecipeIngredient)ingredients.get(0))) : new ObjectArrayList(ingredients);
        this._ingredients = ObjectLists.unmodifiable((ObjectList)copy);
        this._result = result;
    }

    public static <Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractManyToOneRecipe<Ingredient, Result, RecipeIngredient, RecipeResult>> RecipeSerializer<Recipe> createSerializer(String ingredientsFieldName, ModCodecs<RecipeIngredient, RegistryFriendlyByteBuf> ingredientsCodecs, String resultFieldName, ModCodecs<RecipeResult, RegistryFriendlyByteBuf> resultCodecs, BiFunction<List<RecipeIngredient>, RecipeResult, Recipe> recipeFactory) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ingredientsFieldName) ? 1 : 0) != 0, (Object)"Ingredients field name must not be null nor empty");
        Preconditions.checkNotNull(ingredientsCodecs, (Object)"Ingredients codecs must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resultFieldName) ? 1 : 0) != 0, (Object)"Result field name must not be null nor empty");
        Preconditions.checkNotNull(resultCodecs, (Object)"Result codecs must not be null");
        Preconditions.checkNotNull(recipeFactory, (Object)"Recipe factory must not be null");
        final MapCodec codec = RecordCodecBuilder.mapCodec(instance -> instance.group(ingredientsCodecs.listField(ingredientsFieldName, AbstractManyToOneRecipe::getRecipeIngredients), resultCodecs.field(resultFieldName, AbstractManyToOneRecipe::getResult)).apply((Applicative)instance, recipeFactory));
        final StreamCodec streamCodec = StreamCodec.composite(ingredientsCodecs.listStreamCodec(), AbstractManyToOneRecipe::getRecipeIngredients, resultCodecs.streamCodec(), AbstractManyToOneRecipe::getResult, recipeFactory);
        return new RecipeSerializer<Recipe>(){

            public MapCodec<Recipe> codec() {
                return codec;
            }

            public StreamCodec<RegistryFriendlyByteBuf, Recipe> streamCodec() {
                return streamCodec;
            }
        };
    }

    public int getRecipeIngredientsCount() {
        return this._ingredients.size();
    }

    public List<RecipeIngredient> getRecipeIngredients() {
        return this._ingredients;
    }

    public RecipeResult getResult() {
        return this._result;
    }

    @Override
    public boolean test(List<Ingredient> stacks) {
        ObjectArrayList ingredients = this.getRecipeIngredients();
        int ingredientsCount = ingredients.size();
        if (ingredientsCount != stacks.size()) {
            return false;
        }
        if (1 == ingredientsCount) {
            return ((IRecipeIngredient)ingredients.get(0)).test(stacks.get(0));
        }
        ingredients = new ObjectArrayList(ingredients);
        ingredientsCount = ingredients.size();
        for (Ingredient stack : stacks) {
            boolean found = false;
            for (int idx = 0; idx < ingredientsCount; ++idx) {
                if (!((IRecipeIngredient)ingredients.get(idx)).test(stack)) continue;
                ingredients.remove(idx);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return AbstractManyToOneRecipe.buildVanillaIngredientsList(this.getRecipeIngredients().stream().flatMap(i -> i.asVanillaIngredients().stream()).collect(Collectors.toList()));
    }
}

