/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.derivative;

import com.google.common.base.Suppliers;
import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.util.TagUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AlchemicalDerivativeItem
extends Item {
    private static final Map<Holder<Item>, ItemStack> sourceItemCache = new Object2ObjectOpenHashMap();
    private static final Map<TagKey<Item>, ItemStack> sourceTagCache = new Object2ObjectOpenHashMap();
    public boolean useAutomaticIconRendering = true;
    public boolean useAutomaticNameRendering = true;
    public boolean useAutomaticNameLangGeneration = true;
    public boolean provideAutomaticTooltipData = true;
    public boolean useAutomaticTooltipLangGeneration = true;
    public boolean useCustomSourceName = false;
    public Supplier<ItemStack> emptyJarStackSupplier = Suppliers.memoize(() -> new ItemStack((ItemLike)ItemRegistry.EMPTY_JAR_ICON.get()));
    public AlchemicalDerivativeTier tier = AlchemicalDerivativeTier.ABUNDANT;

    public AlchemicalDerivativeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack getEmptyJarStack(ItemStack sulfurStack) {
        Item item = sulfurStack.getItem();
        if (item instanceof AlchemicalDerivativeItem) {
            AlchemicalDerivativeItem sulfur = (AlchemicalDerivativeItem)item;
            return sulfur.emptyJarStackSupplier.get();
        }
        return ItemStack.EMPTY;
    }

    public static AlchemicalDerivativeTier getTier(ItemStack sulfurStack) {
        Item item = sulfurStack.getItem();
        if (item instanceof AlchemicalDerivativeItem) {
            AlchemicalDerivativeItem sulfur = (AlchemicalDerivativeItem)item;
            return sulfur.tier;
        }
        return AlchemicalDerivativeTier.ABUNDANT;
    }

    public AlchemicalDerivativeItem tier(AlchemicalDerivativeTier tier) {
        this.tier = tier;
        return this;
    }

    public AlchemicalDerivativeTier tier() {
        return this.tier;
    }

    public AlchemicalDerivativeItem noAuto() {
        this.useAutomaticIconRendering = false;
        this.useAutomaticNameRendering = false;
        this.useAutomaticNameLangGeneration = false;
        this.provideAutomaticTooltipData = false;
        this.useAutomaticTooltipLangGeneration = false;
        return this;
    }

    public AlchemicalDerivativeItem autoIcon(boolean value) {
        this.useAutomaticIconRendering = value;
        return this;
    }

    public AlchemicalDerivativeItem withJarIcon(Supplier<ItemStack> emptyJarStackSupplier) {
        this.emptyJarStackSupplier = emptyJarStackSupplier;
        return this;
    }

    public AlchemicalDerivativeItem autoName(boolean value) {
        return this.autoName(value, value);
    }

    public AlchemicalDerivativeItem autoName(boolean rendering, boolean langGeneration) {
        this.useAutomaticNameRendering = rendering;
        this.useAutomaticNameLangGeneration = langGeneration;
        return this;
    }

    public AlchemicalDerivativeItem autoTooltip(boolean value) {
        return this.autoTooltip(value, value);
    }

    public AlchemicalDerivativeItem autoTooltip(boolean rendering, boolean langGeneration) {
        this.provideAutomaticTooltipData = rendering;
        this.useAutomaticTooltipLangGeneration = langGeneration;
        return this;
    }

    public AlchemicalDerivativeItem useCustomSourceName(boolean value) {
        this.useCustomSourceName = value;
        return this;
    }

    public MutableComponent formatSourceName(MutableComponent sourceName, AlchemicalDerivativeTier tier) {
        return sourceName.withStyle(Style.EMPTY.withColor(tier.color()).withItalic(Boolean.valueOf(true)));
    }

    public ItemStack getSourceStack(ItemStack stack) {
        if (stack.has(DataComponentRegistry.SOURCE_ITEM)) {
            return sourceItemCache.computeIfAbsent((Holder<Item>)((Holder)stack.get(DataComponentRegistry.SOURCE_ITEM)), ItemStack::new);
        }
        if (stack.has(DataComponentRegistry.SOURCE_TAG)) {
            return sourceTagCache.computeIfAbsent((TagKey<Item>)((TagKey)stack.get(DataComponentRegistry.SOURCE_TAG)), TagUtil::getItemStackForTag);
        }
        return ItemStack.EMPTY;
    }

    public MutableComponent getSourceName(ItemStack pStack) {
        Component component;
        if (this.useCustomSourceName) {
            return this.formatSourceName(Component.translatable((String)(pStack.getDescriptionId() + ".source")), this.tier);
        }
        ItemStack source = this.getSourceStack(pStack);
        if (!source.isEmpty() && (component = source.getHoverName()) instanceof MutableComponent) {
            MutableComponent hoverName = (MutableComponent)component;
            return this.formatSourceName(hoverName, this.tier);
        }
        return Component.translatable((String)"item.theurgy.alchemical_derivative.unknown_source");
    }

    public List<MutableComponent> getTooltipData(ItemStack stack) {
        ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
        if (this.provideAutomaticTooltipData) {
            AlchemicalDerivativeTier tier = AlchemicalDerivativeItem.getTier(stack);
            result.add(this.getSourceName(stack));
            result.add(ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)tier.descriptionId()).withStyle(Style.EMPTY.withColor(tier.color).withItalic(Boolean.valueOf(true)))));
        }
        return result;
    }

    public List<MutableComponent> getNameData(ItemStack stack) {
        ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
        if (this.useAutomaticNameRendering) {
            AlchemicalDerivativeTier tier = AlchemicalDerivativeItem.getTier(stack);
            result.add(ComponentUtils.wrapInSquareBrackets((Component)this.getSourceName(stack)));
            result.add(ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)tier.descriptionId()).withStyle(Style.EMPTY.withColor(tier.color).withItalic(Boolean.valueOf(true)))));
        }
        return result;
    }

    @NotNull
    public Component getName(@NotNull ItemStack pStack) {
        if (this.useAutomaticNameRendering) {
            List<MutableComponent> translationArgs = this.getNameData(pStack);
            return Component.translatable((String)this.getDescriptionId(pStack), (Object[])translationArgs.toArray());
        }
        return super.getName(pStack);
    }
}

