/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.divinationrod;

import com.klikli_dev.theurgy.content.entity.FollowProjectile;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageSetDivinationResult;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.SoundRegistry;
import com.klikli_dev.theurgy.scanner.ScanManager;
import com.klikli_dev.theurgy.util.EntityUtil;
import com.klikli_dev.theurgy.util.LevelUtil;
import com.klikli_dev.theurgy.util.TagUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DivinationRodItem
extends Item {
    public static final float NOT_FOUND = 7.0f;
    public static final float SEARCHING = 8.0f;
    public Tiers defaultTier;
    public TagKey<Block> defaultAllowedBlocksTag;
    public TagKey<Block> defaultDisallowedBlocksTag;
    public int defaultRange;
    public int defaultDuration;
    public int defaultDurability;
    public boolean defaultAllowAttuning;
    private static final Map<Holder<Block>, ItemStack> linkedBlockCache = new Object2ObjectOpenHashMap();
    private static final Map<TagKey<Block>, ItemStack> linkedTagCache = new Object2ObjectOpenHashMap();

    public DivinationRodItem(Item.Properties pProperties, Tiers defaultTier, TagKey<Block> defaultAllowedBlocksTag, TagKey<Block> defaultDisallowedBlocksTag, int defaultRange, int defaultDuration, int defaultDurability, boolean defaultAllowAttuning) {
        super(pProperties.component(DataComponentRegistry.DIVINATION_SETTINGS_TIER, (Object)defaultTier).component(DataComponentRegistry.DIVINATION_SETTINGS_ALLOWED_BLOCKS_TAG, defaultAllowedBlocksTag).component(DataComponentRegistry.DIVINATION_SETTINGS_DISALLOWED_BLOCKS_TAG, defaultDisallowedBlocksTag).component(DataComponentRegistry.DIVINATION_SETTINGS_RANGE, (Object)defaultRange).component(DataComponentRegistry.DIVINATION_SETTINGS_DURATION, (Object)defaultDuration).component(DataComponentRegistry.DIVINATION_SETTINGS_MAX_DAMAGE, (Object)defaultDurability).component(DataComponentRegistry.DIVINATION_SETTINGS_ALLOW_ATTUNING, (Object)defaultAllowAttuning));
        this.defaultTier = defaultTier;
        this.defaultAllowedBlocksTag = defaultAllowedBlocksTag;
        this.defaultDisallowedBlocksTag = defaultDisallowedBlocksTag;
        this.defaultRange = defaultRange;
        this.defaultDuration = defaultDuration;
        this.defaultDurability = defaultDurability;
        this.defaultAllowAttuning = defaultAllowAttuning;
    }

    public static ItemStack getLinkedBlockStack(ItemStack divinationRod) {
        if (divinationRod.has(DataComponentRegistry.DIVINATION_LINKED_BLOCK)) {
            return linkedBlockCache.computeIfAbsent((Holder<Block>)((Holder)divinationRod.get(DataComponentRegistry.DIVINATION_LINKED_BLOCK)), b -> new ItemStack((ItemLike)b.value()));
        }
        if (divinationRod.has(DataComponentRegistry.DIVINATION_LINKED_TAG)) {
            return linkedTagCache.computeIfAbsent((TagKey<Block>)((TagKey)divinationRod.get(DataComponentRegistry.DIVINATION_LINKED_TAG)), TagUtil::getItemStackForBlockTag);
        }
        return ItemStack.EMPTY;
    }

    private static void scanLinkedBlock(Player player, Holder<Block> blockHolder, int range, int duration) {
        Set<Block> blocks = DivinationRodItem.getScanTargetsForId(((ResourceKey)blockHolder.unwrapKey().get()).location());
        ScanManager.get().beginScan(player, blocks, range, duration);
    }

    private static void scanLinkedTag(Player player, TagKey<Block> tagKey, int range, int duration) {
        Set<Block> blocks = BuiltInRegistries.BLOCK.getTag(tagKey).map(tag -> tag.stream().map(Holder::value).collect(Collectors.toSet())).orElse(Collections.emptySet());
        if (!blocks.isEmpty()) {
            ScanManager.get().beginScan(player, blocks, range, duration);
        }
    }

    public static Set<Block> getScanTargetsForId(ResourceLocation linkedBlockId) {
        TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DivinationRodItem.getOreTagFromBlockId(linkedBlockId));
        Optional tag = BuiltInRegistries.BLOCK.getTag(tagKey);
        if (tag.map(HolderSet.ListBacked::size).orElse(0) > 0) {
            return tag.map(t -> t.stream().map(Holder::value).collect(Collectors.toSet())).orElse(Collections.emptySet());
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(linkedBlockId);
        if (block != null) {
            Block deepslateBlock = null;
            if (linkedBlockId.getPath().contains("_ore") && !linkedBlockId.getPath().contains("deepslate_")) {
                ResourceLocation deepslateId = ResourceLocation.fromNamespaceAndPath((String)linkedBlockId.getNamespace(), (String)("deepslate_" + linkedBlockId.getPath()));
                deepslateBlock = (Block)BuiltInRegistries.BLOCK.get(deepslateId);
            }
            return deepslateBlock != null && deepslateBlock != Blocks.AIR ? Set.of(block, deepslateBlock) : Set.of(block);
        }
        return Set.of();
    }

    public static ResourceLocation getOreTagFromBlockId(ResourceLocation blockId) {
        String path = blockId.getPath();
        String oreName = path.replace("_ore", "").replace("ore_", "").replace("_deepslate", "").replace("deepslate_", "");
        return ResourceLocation.parse((String)("c:ores/" + oreName));
    }

    public static void registerCreativeModeTabs(DivinationRodItem item, CreativeModeTab.Output output) {
        Level level = LevelUtil.getLevelWithoutContext();
        if (level != null) {
            RecipeManager recipeManager = level.getRecipeManager();
            recipeManager.getRecipes().forEach(recipe -> {
                if (recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()) != null && recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() == item) {
                    output.accept(recipe.value().getResultItem((HolderLookup.Provider)level.registryAccess()).copy());
                }
            });
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_MAX_DAMAGE, (Object)1);
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pLivingEntity.level().isClientSide && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            ScanManager.get().updateScan(player, false);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Tier tier = this.getMiningTier(stack);
        TagKey<Block> allowedBlocksTag = this.getAllowedBlocksTag(stack);
        TagKey<Block> disallowedBlocksTag = this.getDisallowedBlocksTag(stack);
        if (player.isShiftKeyDown()) {
            if (!((Boolean)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_ALLOW_ATTUNING, (Object)false)).booleanValue()) {
                if (!level.isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.theurgy.divination_rod.attuning_not_allowed"));
                }
                return InteractionResult.FAIL;
            }
            BlockState state = level.getBlockState(pos);
            if (!state.isAir()) {
                if (state.is(tier.getIncorrectBlocksForDrops())) {
                    if (!level.isClientSide) {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.theurgy.divination_rod.tier_too_low", (Object[])new Object[]{this.getBlockDisplayComponent(state.getBlock())}));
                    }
                    return InteractionResult.FAIL;
                }
                if (!state.is(allowedBlocksTag)) {
                    if (!level.isClientSide) {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.theurgy.divination_rod.block_not_allowed", (Object[])new Object[]{this.getBlockDisplayComponent(state.getBlock())}));
                    }
                    return InteractionResult.FAIL;
                }
                if (state.is(disallowedBlocksTag)) {
                    if (!level.isClientSide) {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.theurgy.divination_rod.block_disallowed", (Object[])new Object[]{this.getBlockDisplayComponent(state.getBlock())}));
                    }
                    return InteractionResult.FAIL;
                }
                if (!level.isClientSide) {
                    stack.set(DataComponentRegistry.DIVINATION_LINKED_BLOCK, (Object)state.getBlockHolder());
                    player.sendSystemMessage((Component)Component.translatable((String)"message.theurgy.divination_rod.linked", (Object[])new Object[]{this.getBlockDisplayComponent(state.getBlock())}));
                }
                level.playSound(player, player.blockPosition(), SoundRegistry.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown()) {
            if (stack.has(DataComponentRegistry.DIVINATION_LINKED_BLOCK) || stack.has(DataComponentRegistry.DIVINATION_LINKED_TAG)) {
                stack.set(DataComponentRegistry.DIVINATION_DISTANCE, (Object)Float.valueOf(8.0f));
                player.startUsingItem(hand);
                level.playSound(player, player.blockPosition(), SoundRegistry.TUNING_FORK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (level.isClientSide) {
                    if (stack.has(DataComponentRegistry.DIVINATION_LINKED_TAG)) {
                        DivinationRodItem.scanLinkedTag(player, (TagKey<Block>)((TagKey)stack.get(DataComponentRegistry.DIVINATION_LINKED_TAG)), (Integer)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_RANGE, (Object)this.defaultRange), (Integer)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_DURATION, (Object)this.defaultDuration));
                    } else if (stack.has(DataComponentRegistry.DIVINATION_LINKED_BLOCK)) {
                        DivinationRodItem.scanLinkedBlock(player, (Holder<Block>)((Holder)stack.get(DataComponentRegistry.DIVINATION_LINKED_BLOCK)), (Integer)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_RANGE, (Object)this.defaultRange), (Integer)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_DURATION, (Object)this.defaultDuration));
                    }
                }
            } else if (!level.isClientSide) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.theurgy.divination_rod.no_link"));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        if (stack.getDamageValue() >= stack.getMaxDamage()) {
            player.onEquippedItemBroken(stack.getItem(), LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            Item item = stack.getItem();
            stack.shrink(1);
            player.awardStat(Stats.ITEM_BROKEN.get((Object)item));
            stack.setDamageValue(0);
            return stack;
        }
        player.getCooldowns().addCooldown((Item)this, ((Integer)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_DURATION, (Object)this.defaultDuration)).intValue());
        stack.set(DataComponentRegistry.DIVINATION_DISTANCE, (Object)Float.valueOf(7.0f));
        if (level.isClientSide) {
            BlockPos result = ScanManager.get().finishScan(player);
            float distance = this.getDistance(player.position(), result);
            stack.set(DataComponentRegistry.DIVINATION_DISTANCE, (Object)Float.valueOf(distance));
            Networking.sendToServer(new MessageSetDivinationResult(result, distance));
            if (result != null) {
                stack.set(DataComponentRegistry.DIVINATION_POS, (Object)result);
                this.spawnResultParticle(result, level, (LivingEntity)player);
            }
        } else if (!player.getAbilities().instabuild) {
            stack.setDamageValue(stack.getDamageValue() + 1);
        }
        return stack;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return (Integer)pStack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_DURATION, (Object)this.defaultDuration);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity pLivingEntity, int pTimeCharged) {
        if (!stack.has(DataComponentRegistry.DIVINATION_POS)) {
            stack.set(DataComponentRegistry.DIVINATION_DISTANCE, (Object)Float.valueOf(7.0f));
        } else {
            float distance = this.getDistance(pLivingEntity.position(), (BlockPos)stack.get(DataComponentRegistry.DIVINATION_POS));
            stack.set(DataComponentRegistry.DIVINATION_DISTANCE, (Object)Float.valueOf(distance));
        }
        if (level.isClientSide) {
            ScanManager.get().cancelScan();
            if (stack.has(DataComponentRegistry.DIVINATION_POS)) {
                this.spawnResultParticle((BlockPos)stack.get(DataComponentRegistry.DIVINATION_POS), level, pLivingEntity);
            }
        }
        super.releaseUsing(stack, level, pLivingEntity, pTimeCharged);
    }

    public Component getName(ItemStack pStack) {
        if (pStack.has(DataComponentRegistry.DIVINATION_LINKED_BLOCK) || pStack.has(DataComponentRegistry.DIVINATION_LINKED_TAG)) {
            ItemStack stack = DivinationRodItem.getLinkedBlockStack(pStack);
            if (!stack.isEmpty()) {
                MutableComponent blockComponent = ComponentUtils.wrapInSquareBrackets((Component)Component.empty().append(stack.getHoverName()).withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withItalic(Boolean.valueOf(true)))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack))));
                return Component.translatable((String)(this.getDescriptionId() + ".linked"), (Object[])new Object[]{blockComponent});
            }
            MutableComponent blockComponent = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"item.theurgy.divination_rod.unknown_linked_block").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withItalic(Boolean.valueOf(true)))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack))));
            return Component.translatable((String)(this.getDescriptionId() + ".linked"), (Object[])new Object[]{blockComponent});
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (pStack.has(DataComponentRegistry.DIVINATION_LINKED_BLOCK) || pStack.has(DataComponentRegistry.DIVINATION_LINKED_TAG)) {
            ItemStack stack = DivinationRodItem.getLinkedBlockStack(pStack);
            if (!stack.isEmpty()) {
                MutableComponent blockComponent = Component.empty().append(stack.getHoverName()).withStyle(ChatFormatting.GREEN).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack))));
                this.getBlockDisplayComponent(stack);
                pTooltipComponents.add((Component)Component.translatable((String)"tooltip.theurgy..divination_rod.linked_to", (Object[])new Object[]{blockComponent}).withStyle(ChatFormatting.GRAY));
                if (pStack.has(DataComponentRegistry.DIVINATION_POS)) {
                    pTooltipComponents.add((Component)Component.translatable((String)"tooltip.theurgy..divination_rod.last_result", (Object[])new Object[]{blockComponent, ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)((BlockPos)pStack.get(DataComponentRegistry.DIVINATION_POS)).toShortString()).withStyle(ChatFormatting.GREEN))}).withStyle(ChatFormatting.GRAY));
                }
            }
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.theurgy..divination_rod.no_link"));
        }
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public float getDistance(Vec3 playerPosition, BlockPos result) {
        if (result == null) {
            return 7.0f;
        }
        Vec3 resultCenter = Vec3.atCenterOf((Vec3i)result);
        Vec3 playerPosition2d = new Vec3(playerPosition.x, 0.0, playerPosition.z);
        Vec3 resultCenter2d = new Vec3(resultCenter.x, 0.0, resultCenter.z);
        double distance = playerPosition2d.distanceTo(resultCenter2d);
        if (distance < 6.0) {
            return 0.0f;
        }
        if (distance < 15.0) {
            return 1.0f;
        }
        if (distance < 25.0) {
            return 2.0f;
        }
        if (distance < 35.0) {
            return 3.0f;
        }
        if (distance < 45.0) {
            return 4.0f;
        }
        if (distance < 65.0) {
            return 5.0f;
        }
        return 6.0f;
    }

    protected MutableComponent getBlockDisplayComponent(Block block) {
        return this.getBlockDisplayComponent(new ItemStack((ItemLike)block));
    }

    protected MutableComponent getBlockDisplayComponent(ItemStack stack) {
        Component displayName = stack.getHoverName();
        return ComponentUtils.wrapInSquareBrackets((Component)displayName).withStyle(ChatFormatting.GREEN).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack))));
    }

    protected void spawnResultParticle(BlockPos result, Level level, LivingEntity entity) {
        Vec3 to;
        float visualizationRange = 10.0f;
        Vec3 from = new Vec3(entity.getX(), entity.getEyeY() - (double)0.1f, entity.getZ());
        Vec3 resultVec = Vec3.atCenterOf((Vec3i)result);
        Vec3 dist = resultVec.subtract(from);
        Vec3 dir = dist.normalize();
        Vec3 vec3 = to = dist.length() <= 10.0 ? resultVec : from.add(dir.scale(10.0));
        if (level.isLoaded(BlockPos.containing((Position)to)) && level.isLoaded(BlockPos.containing((Position)from)) && level.isClientSide) {
            FollowProjectile aoeProjectile = new FollowProjectile(level, from, to, 255, 25, 180, 0.25f);
            EntityUtil.spawnEntityClientSide(level, (Entity)aoeProjectile, true);
        }
    }

    public Tier getMiningTier(ItemStack stack) {
        return (Tier)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_TIER, (Object)this.defaultTier);
    }

    public TagKey<Block> getAllowedBlocksTag(ItemStack stack) {
        return (TagKey)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_ALLOWED_BLOCKS_TAG, this.defaultAllowedBlocksTag);
    }

    public TagKey<Block> getDisallowedBlocksTag(ItemStack stack) {
        return (TagKey)stack.getOrDefault(DataComponentRegistry.DIVINATION_SETTINGS_DISALLOWED_BLOCKS_TAG, this.defaultDisallowedBlocksTag);
    }

    public static class DistHelper {
        public static ItemPropertyFunction DIVINATION_DISTANCE = (stack, world, entity, i) -> {
            if (((Float)stack.getOrDefault(DataComponentRegistry.DIVINATION_DISTANCE, (Object)Float.valueOf(-1.0f))).floatValue() < 0.0f) {
                return 7.0f;
            }
            return ((Float)stack.get(DataComponentRegistry.DIVINATION_DISTANCE)).floatValue();
        };
    }
}

