/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import com.klikli_dev.theurgy.content.behaviour.filter.FilterMode;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemAttribute;
import com.klikli_dev.theurgy.content.item.filter.AbstractFilterMenu;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.MenuTypeRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class AttributeFilterMenu
extends AbstractFilterMenu {
    public FilterMode filterMode;
    public List<Pair<ItemAttribute, Boolean>> selectedAttributes;

    protected AttributeFilterMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected AttributeFilterMenu(MenuType<?> type, int id, Inventory inv, ItemStack contentHolder) {
        super(type, id, inv, contentHolder);
    }

    public static AttributeFilterMenu create(int id, Inventory inv, ItemStack stack) {
        return new AttributeFilterMenu((MenuType)MenuTypeRegistry.ATTRIBUTE_FILTER.get(), id, inv, stack);
    }

    public static AttributeFilterMenu create(int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        return new AttributeFilterMenu((MenuType)MenuTypeRegistry.ATTRIBUTE_FILTER.get(), id, inv, extraData);
    }

    @Override
    protected ComponentItemHandler createGhostInventory() {
        return new ComponentItemHandler((MutableDataComponentHolder)this.contentHolder, (DataComponentType)DataComponentRegistry.FILTER_ITEMS.get(), 2);
    }

    @Override
    protected int getPlayerInventoryXOffset() {
        return 40;
    }

    @Override
    protected int getPlayerInventoryYOffset() {
        return 107;
    }

    @Override
    protected void addFilterSlots() {
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.ghostInventory, 0, 16, 24));
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.ghostInventory, 1, 22, 59){

            public boolean mayPickup(@NotNull Player playerIn) {
                return false;
            }
        });
    }

    @Override
    protected void init(Inventory inv, ItemStack contentHolderIn) {
        super.init(inv, contentHolderIn);
        ItemStack stack = new ItemStack((ItemLike)Items.NAME_TAG);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Selected Tags").withStyle(new ChatFormatting[]{ChatFormatting.RESET, ChatFormatting.BLUE}));
        this.ghostInventory.setStackInSlot(1, stack);
    }

    @Override
    public void clicked(int slotId, int dragType, @NotNull ClickType clickTypeIn, @NotNull Player player) {
        if (slotId == 37) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public boolean canDragTo(Slot slotIn) {
        if (slotIn.index == 37) {
            return false;
        }
        return super.canDragTo(slotIn);
    }

    @Override
    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, Slot slotIn) {
        if (slotIn.index == 37) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slotIn);
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        if (index == 37) {
            return ItemStack.EMPTY;
        }
        if (index == 36) {
            this.ghostInventory.setStackInSlot(37, ItemStack.EMPTY);
            return ItemStack.EMPTY;
        }
        if (index < 36) {
            ItemStack stackToInsert = this.playerInventory.getItem(index);
            ItemStack copy = stackToInsert.copy();
            copy.setCount(1);
            this.ghostInventory.setStackInSlot(0, copy);
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected void initAndReadInventory(ItemStack filterItem) {
        super.initAndReadInventory(filterItem);
        this.filterMode = (FilterMode)((Object)((ItemStack)this.contentHolder).getOrDefault(DataComponentRegistry.FILTER_MODE, (Object)FilterMode.ACCEPT_LIST_OR));
        this.selectedAttributes = new ArrayList<Pair<ItemAttribute, Boolean>>();
        CompoundTag tag = ((CustomData)filterItem.getOrDefault(DataComponentRegistry.FILTER_ATTRIBUTES, (Object)CustomData.EMPTY)).getUnsafe();
        ListTag attributes = tag.getList("MatchedAttributes", 10);
        attributes.forEach(inbt -> {
            CompoundTag compound = (CompoundTag)inbt;
            this.selectedAttributes.add((Pair<ItemAttribute, Boolean>)Pair.of((Object)ItemAttribute.of((HolderLookup.Provider)this.player.registryAccess(), compound), (Object)compound.getBoolean("Inverted")));
        });
    }

    @Override
    protected void saveData(ItemStack contentHolder) {
        contentHolder.set(DataComponentRegistry.FILTER_MODE, (Object)this.filterMode);
        ListTag attributes = new ListTag();
        this.selectedAttributes.forEach(at -> {
            if (at == null) {
                return;
            }
            CompoundTag compoundNBT = new CompoundTag();
            ((ItemAttribute)at.getFirst()).serializeNBT((HolderLookup.Provider)this.player.registryAccess(), compoundNBT);
            compoundNBT.putBoolean("Inverted", ((Boolean)at.getSecond()).booleanValue());
            attributes.add((Object)compoundNBT);
        });
        CompoundTag tag = new CompoundTag();
        tag.put("MatchedAttributes", (Tag)attributes);
        contentHolder.set(DataComponentRegistry.FILTER_ATTRIBUTES, (Object)CustomData.of((CompoundTag)tag));
    }

    @Override
    public void clearContents() {
        this.selectedAttributes.clear();
    }
}

