/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccumulationRecipe
implements Recipe<ItemHandlerWithFluidRecipeInput> {
    public static final int DEFAULT_TIME = 100;
    public static final MapCodec<AccumulationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedFluidIngredient.NESTED_CODEC.optionalFieldOf("evaporant").forGetter(r -> Optional.ofNullable(r.evaporant)), (App)Ingredient.CODEC.optionalFieldOf("solute").forGetter(r -> Optional.ofNullable(r.solute)), (App)FluidStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("time", (Object)100).forGetter(r -> r.time)).apply((Applicative)instance, (evaporant, solute, result, accumulation_time) -> new AccumulationRecipe(evaporant.orElse(null), solute.orElse(null), (FluidStack)result, (int)accumulation_time)));
    public static final StreamCodec<RegistryFriendlyByteBuf, AccumulationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)SizedFluidIngredient.STREAM_CODEC), r -> Optional.ofNullable(r.evaporant), (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), r -> Optional.ofNullable(r.solute), (StreamCodec)FluidStack.STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.INT, r -> r.time, (evaporant, solute, result, accumulation_time) -> new AccumulationRecipe(evaporant.orElse(null), solute.orElse(null), (FluidStack)result, (int)accumulation_time));
    @Nullable
    protected final SizedFluidIngredient evaporant;
    @Nullable
    protected final Ingredient solute;
    protected final FluidStack result;
    protected final int time;

    public AccumulationRecipe(@Nullable SizedFluidIngredient evaporant, @Nullable Ingredient solute, FluidStack result, int time) {
        this.evaporant = evaporant;
        this.solute = solute;
        this.result = result;
        this.time = time;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.ACCUMULATION.get();
    }

    public boolean matches(@NotNull ItemHandlerWithFluidRecipeInput pContainer, @NotNull Level pLevel) {
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        boolean evaporantMatches = !this.hasEvaporant() || this.evaporant.test(fluid);
        boolean soluteMatches = pContainer.getItem(0).isEmpty() && !this.hasSolute() || this.hasSolute() && this.solute.test(pContainer.getItem(0));
        return soluteMatches && evaporantMatches;
    }

    @NotNull
    public ItemStack assemble(@NotNull ItemHandlerWithFluidRecipeInput pInv, @NotNull HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public FluidStack assembleFluid(@NotNull ItemHandlerWithFluidRecipeInput pInv, @NotNull HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        if (this.solute != null) {
            nonnulllist.add((Object)this.solute);
        }
        return nonnulllist;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ItemRegistry.SAL_AMMONIAC_ACCUMULATOR.get());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializerRegistry.ACCUMULATION.get();
    }

    public int getTime() {
        return this.time;
    }

    @Nullable
    public SizedFluidIngredient getEvaporant() {
        return this.evaporant;
    }

    public int getEvaporantAmount() {
        return this.hasEvaporant() ? this.evaporant.amount() : 0;
    }

    @Nullable
    public Ingredient getSolute() {
        return this.solute;
    }

    public boolean hasSolute() {
        return this.solute != null;
    }

    public boolean hasEvaporant() {
        return this.evaporant != null;
    }

    public FluidStack getResult() {
        return this.result;
    }

    public static class Serializer
    implements RecipeSerializer<AccumulationRecipe> {
        @NotNull
        public MapCodec<AccumulationRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, AccumulationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

