/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.exaltation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class ConvertToOtherTierEntry
extends EntryProvider {
    public static final String ENTRY_ID = "convert_to_other_tier";

    public ConvertToOtherTierEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Exaltation");
        this.pageText("Exaltation is the elevation of matter from one tier to another (e.g. Common to Rare).\n\\\n\\\nThus, exaltation breaches the final barrier of transformation, allowing you to obtain any material you desire.\n");
        this.page("intro2", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Exaltation");
        this.pageText("Due to the nature of exaltation, it is a very costly process. Matter cannot simply be made more valuable.\\\nThus there is a loss or gain, depending on the direction of conversion.\\\nGenerally, 4 units of the lower tier are required to obtain 1 unit of the higher tier and vice versa.\n");
        this.page("digestion", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Digestion");
        this.pageText("The core of the Exaltation Process is the Digestion of Niter into other Niter, in a {0}.\n\\\n\\\nDigestion needs a Catalysator in the form of {1}, which will be explained soon.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.DIGESTION_VAT.get()), this.itemLink((ItemLike)ItemRegistry.PURIFIED_GOLD.get())});
        this.page("process", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Process");
        this.pageText("Exaltation consists of three steps.\n\\\n\\\nFirst, the Sulfur to be transformed is fermented alchemically into Niter (e.g. Iron Sulfur into Common Metals Niter).\\\nThen that 4 of that Niter can be digested into 1 Niter of the desired type (e.g. Common Metals Niter into Rare Metals Niter).\n");
        this.page("process2", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Process");
        this.pageText("*(Optionally that Niter can be reformed into a Niter of another type (e.g. Rare Metals Niter into Rare Gems Niter))*\n\\\n\\\nFinally that Niter can be reformed again into the desired Sulfur (e.g. Rare Metals Niter into Gold Sulfur).\n");
        this.page("instructions", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Instructions");
        this.pageText("The following entries will guide you through the conversion of {0} into {1}. *This assumes you already obtained at least 4 Iron Sulfur and one Gold Sulfur*.\n\\\n\\\nThe instructions also apply to all other conversions between different tiers.\n", new Object[]{this.itemLink("Alchemical Sulfur: Iron", (ItemLike)SulfurRegistry.IRON.get()), this.itemLink("Alchemical Sulfur: Gold", (ItemLike)SulfurRegistry.GOLD.get())});
    }

    protected String entryName() {
        return "Replication by Exaltation";
    }

    protected String entryDescription() {
        return "Obtaining more of an item by converting items of a different tier.";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return Pair.of((Object)0, (Object)2);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ResourceLocation)this.modLoc("textures/gui/book/convert_tiers.png"));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

