/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;

public abstract class DSLSupport {
    private static final ClassValue<Enum<?>[]> ENUM_CONSTANTS = new ClassValue<Enum<?>[]>(){

        @Override
        protected Enum<?>[] computeValue(Class<?> type) {
            return (Enum[])type.getEnumConstants();
        }
    };

    private DSLSupport() {
    }

    public static <T extends Enum<?>> T[] lookupEnumConstants(Class<T> c2) {
        return ENUM_CONSTANTS.get(c2);
    }

    public static <T extends NodeInterface> T maybeInsert(Node node, T o2) {
        if (o2 instanceof Node) {
            node.insert((Node)o2);
        }
        return o2;
    }

    public static <T extends NodeInterface> T[] maybeInsert(Node node, T[] o2) {
        if (o2 instanceof Node[]) {
            node.insert((Node[])o2);
        }
        return o2;
    }

    public static boolean assertIdempotence(boolean guardValue) {
        if (!guardValue) {
            throw new AssertionError((Object)"A guard was assumed idempotent, but returned a different value for a consecutive execution.");
        }
        return true;
    }

    public static interface SpecializationDataNode {
    }
}

