/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class ArrayBufferPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ArrayBufferPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ArrayBufferPrototypeBuiltins();

    protected ArrayBufferPrototypeBuiltins() {
        super(JSArrayBuffer.PROTOTYPE_NAME, ArrayBufferPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ArrayBufferPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 1: {
                return ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferSliceNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 0: 
            case 5: {
                return ArrayBufferPrototypeBuiltinsFactory.ByteLengthGetterNodeGen.create(context, builtin, builtinEnum == ArrayBufferPrototype.maxByteLength, ArrayBufferPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: {
                return ArrayBufferPrototypeBuiltinsFactory.DetachedGetterNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 3: {
                return ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferTransferNodeGen.create(context, builtin, true, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferTransferNodeGen.create(context, builtin, false, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 6: {
                return ArrayBufferPrototypeBuiltinsFactory.ResizableGetterNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 7: {
                return ArrayBufferPrototypeBuiltinsFactory.JSArrayBufferResizeNodeGen.create(context, builtin, ArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ArrayBufferPrototype implements BuiltinEnum<ArrayBufferPrototype>
    {
        byteLength(0),
        slice(2),
        detached(0),
        transfer(0),
        transferToFixedLength(0),
        maxByteLength(0),
        resizable(0),
        resize(1);

        private final int length;

        private ArrayBufferPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return switch (this.ordinal()) {
                case 0, 2, 5, 6 -> true;
                default -> false;
            };
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 2, 3, 4, 5, 6, 7 -> 15;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }
    }

    @ImportStatic(value={JSArrayBuffer.class, JSConfig.class})
    public static abstract class JSArrayBufferSliceNode
    extends JSArrayBufferAbstractSliceNode {
        public JSArrayBufferSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSArrayBufferObject sliceIntInt(JSArrayBufferObject.Heap thisObj, int begin, int end, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            int byteLength = thisObj.getByteLength();
            byte[] byteArray = JSArrayBuffer.getByteArray(thisObj);
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, byteLength);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, byteLength);
            int newLen = Math.max(clampedEnd - clampedBegin, 0);
            JSArrayBufferObject resObj = this.constructNewArrayBuffer(thisObj, newLen, false, errorBranch);
            byte[] newByteArray = JSArrayBuffer.getByteArray(resObj);
            System.arraycopy(byteArray, clampedBegin, newByteArray, 0, newLen);
            return resObj;
        }

        private JSArrayBufferObject constructNewArrayBuffer(JSArrayBufferObject thisObj, int newLen, boolean direct, InlinedBranchProfile errorBranch) {
            JSFunctionObject defaultConstructor = this.getRealm().getArrayBufferConstructor();
            Object constr = this.getArraySpeciesConstructorNode().speciesConstructor(thisObj, defaultConstructor);
            Object resObj = this.getArraySpeciesConstructorNode().construct(constr, newLen);
            if (direct && !JSArrayBuffer.isJSDirectArrayBuffer(resObj) || !direct && !JSArrayBuffer.isJSHeapArrayBuffer(resObj)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorArrayBufferExpected();
            }
            JSArrayBufferObject newBuffer = (JSArrayBufferObject)resObj;
            this.checkDetachedBuffer(newBuffer, errorBranch);
            if (resObj == thisObj) {
                errorBranch.enter(this);
                throw Errors.createTypeError("SameValue(new, O) is forbidden");
            }
            if (newBuffer.getByteLength() < newLen) {
                errorBranch.enter(this);
                throw Errors.createTypeError("insufficient length constructed");
            }
            this.checkDetachedBuffer(thisObj, errorBranch);
            return newBuffer;
        }

        private void checkDetachedBuffer(JSArrayBufferObject arrayBuffer, InlinedBranchProfile errorBranch) {
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }

        @Specialization(replaces={"sliceIntInt"})
        protected JSArrayBufferObject slice(JSArrayBufferObject.Heap thisObj, Object begin0, Object end0, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            int len = thisObj.getByteLength();
            int begin = this.getStart(begin0, len);
            int finalEnd = this.getEnd(end0, len);
            return this.sliceIntInt(thisObj, begin, finalEnd, errorBranch);
        }

        @Specialization
        protected JSArrayBufferObject sliceDirectIntInt(JSArrayBufferObject.Direct thisObj, int begin, int end, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(thisObj);
            int byteLength = thisObj.getByteLength();
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, byteLength);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, byteLength);
            int newLen = clampedEnd - clampedBegin;
            JSArrayBufferObject resObj = this.constructNewArrayBuffer(thisObj, newLen, true, errorBranch);
            ByteBuffer resBuffer = JSArrayBuffer.getDirectByteBuffer(resObj);
            Boundaries.byteBufferPutSlice(resBuffer, 0, byteBuffer, clampedBegin, clampedEnd);
            return resObj;
        }

        @Specialization(replaces={"sliceDirectIntInt"})
        protected JSArrayBufferObject sliceDirect(JSArrayBufferObject.Direct thisObj, Object begin0, Object end0, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            int len = thisObj.getByteLength();
            int begin = this.getStart(begin0, len);
            int end = this.getEnd(end0, len);
            return this.sliceDirectIntInt(thisObj, begin, end, errorBranch);
        }

        @Specialization
        protected JSArrayBufferObject sliceInterop(JSArrayBufferObject.Interop thisObj, Object begin0, Object end0, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary srcBufferLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary dstBufferLib) {
            this.checkDetachedBuffer(thisObj, errorBranch);
            Object interopBuffer = JSArrayBuffer.getInteropBuffer(thisObj);
            int length = ConstructorBuiltins.ConstructArrayBufferNode.getBufferSizeSafe(interopBuffer, srcBufferLib, this, errorBranch);
            int begin = this.getStart(begin0, length);
            int end = this.getEnd(end0, length);
            int clampedBegin = JSArrayBufferSliceNode.clampIndex(begin, 0, length);
            int clampedEnd = JSArrayBufferSliceNode.clampIndex(end, clampedBegin, length);
            int newLen = Math.max(clampedEnd - clampedBegin, 0);
            JSArrayBufferObject resObj = this.constructNewArrayBuffer(thisObj, newLen, this.getContext().isOptionDirectByteBuffer(), errorBranch);
            this.copyInteropBufferElements(thisObj, resObj, clampedBegin, newLen, errorBranch, srcBufferLib, dstBufferLib);
            return resObj;
        }

        private void copyInteropBufferElements(Object srcBuffer, Object dstBuffer, int srcBufferOffset, int len, InlinedBranchProfile errorBranch, InteropLibrary srcBufferLib, InteropLibrary dstBufferLib) {
            try {
                for (int i2 = 0; i2 < len; ++i2) {
                    dstBufferLib.writeBufferByte(dstBuffer, i2, srcBufferLib.readBufferByte(srcBuffer, srcBufferOffset + i2));
                }
            }
            catch (InvalidBufferOffsetException | UnsupportedMessageException e2) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorInteropException(dstBuffer, e2, "buffer access", null);
            }
        }

        @Specialization(guards={"!isJSSharedArrayBuffer(thisObj)", "hasBufferElements(thisObj, srcBufferLib)"})
        protected JSArrayBufferObject sliceTruffleBuffer(Object thisObj, Object begin0, Object end0, @Cached @Cached.Shared InlinedBranchProfile errorBranch, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary srcBufferLib, @CachedLibrary(limit="InteropLibraryLimit") @Cached.Shared InteropLibrary dstBufferLib) {
            return this.sliceInterop(JSArrayBuffer.createInteropArrayBuffer(this.getContext(), this.getRealm(), thisObj), begin0, end0, errorBranch, srcBufferLib, dstBufferLib);
        }

        @Fallback
        protected static JSArrayBufferObject error(Object thisObj, Object begin0, Object end0) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }

        static boolean hasBufferElements(Object buffer, InteropLibrary interop) {
            return interop.hasBufferElements(buffer);
        }
    }

    @ImportStatic(value={JSArrayBuffer.class, JSConfig.class})
    public static abstract class ByteLengthGetterNode
    extends JSBuiltinNode {
        private final boolean getMaxByteLength;

        public ByteLengthGetterNode(JSContext context, JSBuiltin builtin, boolean getMaxByteLength) {
            super(context, builtin);
            this.getMaxByteLength = getMaxByteLength;
        }

        @Specialization
        protected int heapArrayBuffer(JSArrayBufferObject.Heap thisObj) {
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && thisObj.getByteArray() == null) {
                return 0;
            }
            if (this.getMaxByteLength && !thisObj.isFixedLength()) {
                return thisObj.getMaxByteLength();
            }
            return thisObj.getByteLength();
        }

        @Specialization
        protected int directArrayBuffer(JSArrayBufferObject.Direct thisObj) {
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && thisObj.getByteBuffer() == null) {
                return 0;
            }
            if (this.getMaxByteLength && !thisObj.isFixedLength()) {
                return thisObj.getMaxByteLength();
            }
            return thisObj.getByteLength();
        }

        @Specialization
        protected int interopArrayBuffer(JSArrayBufferObject.Interop thisObj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object buffer = thisObj.getInteropBuffer();
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && buffer == null) {
                return 0;
            }
            if (this.getMaxByteLength && !thisObj.isFixedLength()) {
                return thisObj.getMaxByteLength();
            }
            try {
                long bufferSize = interop.getBufferSize(buffer);
                assert (JSRuntime.longIsRepresentableAsInt(bufferSize));
                return (int)bufferSize;
            }
            catch (UnsupportedMessageException e2) {
                return 0;
            }
        }

        @Fallback
        protected static int error(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class DetachedGetterNode
    extends JSBuiltinNode {
        public DetachedGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSSharedArrayBuffer(arrayBuffer)"})
        protected boolean detached(JSArrayBufferObject arrayBuffer) {
            if (this.getContext().getTypedArrayNotDetachedAssumption().isValid()) {
                return false;
            }
            return arrayBuffer.isDetached();
        }

        @Fallback
        protected static boolean error(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class JSArrayBufferTransferNode
    extends JSBuiltinNode {
        private final boolean preserveResizability;

        public JSArrayBufferTransferNode(JSContext context, JSBuiltin builtin, boolean preserveResizability) {
            super(context, builtin);
            this.preserveResizability = preserveResizability;
        }

        @Specialization
        protected final Object arrayBufferHeap(JSArrayBufferObject.Heap thisObj, Object newLength, @Cached @Cached.Shared JSToIndexNode toIndexNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            return this.transfer(thisObj, newLength, toIndexNode, errorBranch);
        }

        @Specialization
        protected final Object arrayBufferDirect(JSArrayBufferObject.Direct thisObj, Object newLength, @Cached @Cached.Shared JSToIndexNode toIndexNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            return this.transfer(thisObj, newLength, toIndexNode, errorBranch);
        }

        @Specialization
        protected final Object arrayBufferInterop(JSArrayBufferObject.Interop thisObj, Object newLength, @Cached @Cached.Shared JSToIndexNode toIndexNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            return this.transfer(thisObj, newLength, toIndexNode, errorBranch);
        }

        private Object transfer(JSArrayBufferObject arrayBuffer, Object newLength, JSToIndexNode toIndexNode, InlinedBranchProfile errorBranch) {
            JSArrayBufferObject newBuffer;
            boolean allocatingResizableBuffer;
            int newByteLength;
            int oldByteLength = arrayBuffer.getByteLength();
            if (newLength == Undefined.instance) {
                newByteLength = oldByteLength;
            } else {
                long byteLength = toIndexNode.executeLong(newLength);
                if (byteLength > (long)this.getContext().getLanguageOptions().maxTypedArrayLength()) {
                    errorBranch.enter(this);
                    throw Errors.createRangeErrorInvalidBufferSize();
                }
                newByteLength = (int)byteLength;
            }
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorDetachedBuffer();
            }
            int newMaxByteLength = this.preserveResizability ? arrayBuffer.getMaxByteLength() : -1;
            if (arrayBuffer.getDetachKey() != Undefined.instance) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorInvalidDetachKey();
            }
            boolean bl = allocatingResizableBuffer = newMaxByteLength != -1;
            if (allocatingResizableBuffer && newByteLength > newMaxByteLength) {
                errorBranch.enter(this);
                throw Errors.createRangeError("byteLength exceeds maxByteLength");
            }
            JSContext context = this.getContext();
            JSRealm realm = this.getRealm();
            if (arrayBuffer instanceof JSArrayBufferObject.Heap) {
                JSArrayBufferObject.Heap heapArrayBuffer = (JSArrayBufferObject.Heap)arrayBuffer;
                byte[] array = heapArrayBuffer.getByteArray();
                if (oldByteLength < newByteLength) {
                    if (newByteLength <= array.length) {
                        Arrays.fill(array, oldByteLength, newByteLength, (byte)0);
                    } else {
                        byte[] newArray = new byte[newByteLength];
                        System.arraycopy(array, 0, newArray, 0, oldByteLength);
                        array = newArray;
                    }
                }
                newBuffer = JSArrayBuffer.createArrayBuffer(context, realm, array, newByteLength, newMaxByteLength);
            } else if (arrayBuffer instanceof JSArrayBufferObject.Direct) {
                JSArrayBufferObject.Direct directArrayBuffer = (JSArrayBufferObject.Direct)arrayBuffer;
                ByteBuffer byteBuffer = directArrayBuffer.getByteBuffer();
                if (oldByteLength < newByteLength) {
                    if (newByteLength <= byteBuffer.capacity()) {
                        for (int i2 = oldByteLength; i2 < newByteLength; ++i2) {
                            byteBuffer.put(i2, (byte)0);
                        }
                    } else {
                        ByteBuffer newByteBuffer = DirectByteBufferHelper.allocateDirect(newByteLength);
                        Boundaries.byteBufferPutSlice(newByteBuffer, 0, byteBuffer, 0, oldByteLength);
                        byteBuffer = newByteBuffer;
                    }
                }
                newBuffer = JSArrayBuffer.createDirectArrayBuffer(context, realm, byteBuffer, newByteLength, newMaxByteLength);
            } else {
                assert (JSArrayBuffer.isJSInteropArrayBuffer(arrayBuffer));
                throw Errors.createTypeError("Cannot transfer an interop ArrayBuffer");
            }
            JSArrayBuffer.detachArrayBuffer(arrayBuffer);
            return newBuffer;
        }

        @Fallback
        protected static Object error(Object thisObj, Object newLength) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class ResizableGetterNode
    extends JSBuiltinNode {
        public ResizableGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"!isJSSharedArrayBuffer(thisObj)"})
        protected boolean arrayBuffer(JSArrayBufferObject thisObj) {
            return !thisObj.isFixedLength();
        }

        @Fallback
        protected static boolean error(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class JSArrayBufferResizeNode
    extends JSBuiltinNode {
        public JSArrayBufferResizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final Object arrayBufferHeap(JSArrayBufferObject.Heap thisObj, Object newLength, @Cached @Cached.Shared JSToIndexNode toIndexNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            return this.arrayBuffer(thisObj, newLength, toIndexNode, errorBranch);
        }

        @Specialization
        protected final Object arrayBufferDirect(JSArrayBufferObject.Direct thisObj, Object newLength, @Cached @Cached.Shared JSToIndexNode toIndexNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            return this.arrayBuffer(thisObj, newLength, toIndexNode, errorBranch);
        }

        @Specialization
        protected final Object arrayBufferInterop(JSArrayBufferObject.Interop thisObj, Object newLength, @Cached @Cached.Shared JSToIndexNode toIndexNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
            return this.arrayBuffer(thisObj, newLength, toIndexNode, errorBranch);
        }

        private Object arrayBuffer(JSArrayBufferObject thisObj, Object newLength, JSToIndexNode toIndexNode, InlinedBranchProfile errorBranch) {
            if (thisObj.isFixedLength()) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Resizable ArrayBuffer expected!");
            }
            long newByteLengthLong = toIndexNode.executeLong(newLength);
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(thisObj)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorDetachedBuffer();
            }
            if (newByteLengthLong > (long)thisObj.getMaxByteLength()) {
                errorBranch.enter(this);
                throw Errors.createRangeError("newByteLength exceeds maxByteLength");
            }
            int newByteLength = (int)newByteLengthLong;
            if (thisObj instanceof JSArrayBufferObject.Interop) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Cannot resize an interop ArrayBuffer");
            }
            int oldByteLength = thisObj.getByteLength();
            if (newByteLength < oldByteLength) {
                this.getContext().getArrayBufferNotShrunkAssumption().invalidate("ArrayBuffer shrunk");
                if (thisObj instanceof JSArrayBufferObject.Heap) {
                    JSArrayBufferObject.Heap heapArrayBuffer = (JSArrayBufferObject.Heap)thisObj;
                    byte[] array = heapArrayBuffer.getByteArray();
                    Arrays.fill(array, newByteLength, oldByteLength, (byte)0);
                } else {
                    ByteBuffer buffer = ((JSArrayBufferObject.Direct)thisObj).getByteBuffer();
                    for (int i2 = newByteLength; i2 < oldByteLength; ++i2) {
                        buffer.put(i2, (byte)0);
                    }
                }
            }
            thisObj.setByteLength(newByteLength);
            return Undefined.instance;
        }

        @Fallback
        protected static Object error(Object thisObj, Object newLength) {
            throw Errors.createTypeErrorArrayBufferExpected();
        }
    }

    public static abstract class JSArrayBufferAbstractSliceNode
    extends JSArrayBufferOperation {
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;

        public JSArrayBufferAbstractSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected int getStart(Object start, int len) {
            long relativeStart = this.toInteger(start);
            if (relativeStart < 0L) {
                return (int)Math.max((long)len + relativeStart, 0L);
            }
            return (int)Math.min(relativeStart, (long)len);
        }

        protected int getEnd(Object end, int len) {
            long relativeEnd;
            long l2 = relativeEnd = end == Undefined.instance ? (long)len : this.toInteger(end);
            if (relativeEnd < 0L) {
                return (int)Math.max((long)len + relativeEnd, 0L);
            }
            return (int)Math.min(relativeEnd, (long)len);
        }

        protected static int clampIndex(int index, int lowerBound, int upperBound) {
            return JSArrayBufferAbstractSliceNode.clamp(index >= 0 ? index : index + upperBound, lowerBound, upperBound);
        }

        private static int clamp(int index, int lowerBound, int upperBound) {
            return Math.max(Math.min(index, upperBound), lowerBound);
        }

        public ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), true));
            }
            return this.arraySpeciesCreateNode;
        }
    }

    public static abstract class JSArrayBufferOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSToIntegerAsLongNode toIntegerNode;

        public JSArrayBufferOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected long toInteger(Object thisObject) {
            if (this.toIntegerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntegerNode = this.insert(JSToIntegerAsLongNode.create());
            }
            return this.toIntegerNode.executeLong(thisObject);
        }
    }
}

