/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarObjectNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalErrors;

public abstract class TemporalMonthDayFromFieldsNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callMonthDayFromFieldsNode = JSFunctionCallNode.createCall();

    protected TemporalMonthDayFromFieldsNode() {
    }

    public abstract JSTemporalPlainMonthDayObject execute(CalendarMethodsRecord var1, JSDynamicObject var2, JSDynamicObject var3);

    @Specialization
    protected JSTemporalPlainMonthDayObject monthDayFromFields(CalendarMethodsRecord calendarRec, JSDynamicObject fields, JSDynamicObject options, @Cached ToTemporalCalendarObjectNode toCalendar, @Cached InlinedBranchProfile errorBranch) {
        assert (options != null);
        Object calendar = toCalendar.execute(calendarRec.receiver());
        Object monthDay = this.callMonthDayFromFieldsNode.executeCall(JSArguments.create(calendar, calendarRec.monthDayFromFields(), fields, options));
        return this.requireTemporalMonthDay(monthDay, errorBranch);
    }

    private JSTemporalPlainMonthDayObject requireTemporalMonthDay(Object obj, InlinedBranchProfile errorBranch) {
        if (!(obj instanceof JSTemporalPlainMonthDayObject)) {
            errorBranch.enter(this);
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
        return (JSTemporalPlainMonthDayObject)obj;
    }
}

